#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvalue_ MATSETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvalue_ matsetvalue
#endif
PETSC_EXTERN void matsetvalue_(Mat *a, PetscInt *b, PetscInt *c, PetscScalar *d, InsertMode *e, PetscErrorCode *ierr)
{
  *ierr = MatSetValue(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetvalue_ MATGETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetvalue_ matgetvalue
#endif
PETSC_EXTERN void matgetvalue_(Mat *a, PetscInt *b, PetscInt *c, PetscScalar *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = MatGetValue(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluelocal_ MATSETVALUELOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluelocal_ matsetvaluelocal
#endif
PETSC_EXTERN void matsetvaluelocal_(Mat *a, PetscInt *b, PetscInt *c, PetscScalar *d, InsertMode *e, PetscErrorCode *ierr)
{
  *ierr = MatSetValueLocal(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
