#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelaplacian_ MATCREATELAPLACIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelaplacian_ matcreatelaplacian
#endif
PETSC_EXTERN void matcreatelaplacian_(Mat *a, PetscReal *b, PetscBool *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLaplacian(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
