  type, extends(tPetscObject) ::  tKSP
  end type tKSP
  KSP, parameter :: PETSC_NULL_KSP = tKSP(0)
  KSP, target :: PETSC_NULL_KSP_ARRAY(1) = [tKSP(0)]
  KSP, pointer :: PETSC_NULL_KSP_POINTER(:) => PETSC_NULL_KSP_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSP
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSP_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSP_POINTER
#endif

  type, extends(tPetscObject) ::  tKSPGuess
  end type tKSPGuess
  KSPGuess, parameter :: PETSC_NULL_KSPGUESS = tKSPGuess(0)
  KSPGuess, target :: PETSC_NULL_KSPGUESS_ARRAY(1) = [tKSPGuess(0)]
  KSPGuess, pointer :: PETSC_NULL_KSPGUESS_POINTER(:) => PETSC_NULL_KSPGUESS_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPGUESS
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPGUESS_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPGUESS_POINTER
#endif

  type eKSPChebyshevKind
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPChebyshevKind

  KSPChebyshevKind, parameter :: PETSC_NULL_KSPCHEBYSHEVKIND = eKSPChebyshevKind(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPCHEBYSHEVKIND
#endif
    KSPChebyshevKind, parameter :: KSP_CHEBYSHEV_FIRST = eKSPChebyshevKind(0)
    KSPChebyshevKind, parameter :: KSP_CHEBYSHEV_FOURTH = eKSPChebyshevKind(1)
    KSPChebyshevKind, parameter :: KSP_CHEBYSHEV_OPT_FOURTH = eKSPChebyshevKind(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CHEBYSHEV_FIRST
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CHEBYSHEV_FOURTH
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CHEBYSHEV_OPT_FOURTH
#endif

  type eKSPFCDTruncationType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPFCDTruncationType

  KSPFCDTruncationType, parameter :: PETSC_NULL_KSPFCDTRUNCATIONTYPE = eKSPFCDTruncationType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPFCDTRUNCATIONTYPE
#endif
    KSPFCDTruncationType, parameter :: KSP_FCD_TRUNC_TYPE_STANDARD = eKSPFCDTruncationType(0)
    KSPFCDTruncationType, parameter :: KSP_FCD_TRUNC_TYPE_NOTAY = eKSPFCDTruncationType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_FCD_TRUNC_TYPE_STANDARD
!DEC$ ATTRIBUTES DLLEXPORT::KSP_FCD_TRUNC_TYPE_NOTAY
#endif

  type eKSPHPDDMType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPHPDDMType

  KSPHPDDMType, parameter :: PETSC_NULL_KSPHPDDMTYPE = eKSPHPDDMType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPHPDDMTYPE
#endif
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_GMRES = eKSPHPDDMType(0)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_BGMRES = eKSPHPDDMType(1)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_CG = eKSPHPDDMType(2)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_BCG = eKSPHPDDMType(3)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_GCRODR = eKSPHPDDMType(4)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_BGCRODR = eKSPHPDDMType(5)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_BFBCG = eKSPHPDDMType(6)
    KSPHPDDMType, parameter :: KSP_HPDDM_TYPE_PREONLY = eKSPHPDDMType(7)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_GMRES 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_BGMRES 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_CG 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_BCG 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_GCRODR 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_BGCRODR 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_BFBCG 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_TYPE_PREONLY 
#endif

  type eKSPHPDDMPrecision
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPHPDDMPrecision

  KSPHPDDMPrecision, parameter :: PETSC_NULL_KSPHPDDMPRECISION = eKSPHPDDMPrecision(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPHPDDMPRECISION
#endif
    KSPHPDDMPrecision, parameter :: KSP_HPDDM_PRECISION_HALF = eKSPHPDDMPrecision(0)
    KSPHPDDMPrecision, parameter :: KSP_HPDDM_PRECISION_SINGLE = eKSPHPDDMPrecision(1)
    KSPHPDDMPrecision, parameter :: KSP_HPDDM_PRECISION_DOUBLE = eKSPHPDDMPrecision(2)
    KSPHPDDMPrecision, parameter :: KSP_HPDDM_PRECISION_QUADRUPLE = eKSPHPDDMPrecision(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_PRECISION_HALF 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_PRECISION_SINGLE 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_PRECISION_DOUBLE 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_HPDDM_PRECISION_QUADRUPLE 
#endif

  type eKSPGMRESCGSRefinementType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPGMRESCGSRefinementType

  KSPGMRESCGSRefinementType, parameter :: PETSC_NULL_KSPGMRESCGSREFINEMENTTYPE = eKSPGMRESCGSRefinementType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPGMRESCGSREFINEMENTTYPE
#endif
    KSPGMRESCGSRefinementType, parameter :: KSP_GMRES_CGS_REFINE_NEVER = eKSPGMRESCGSRefinementType(0)
    KSPGMRESCGSRefinementType, parameter :: KSP_GMRES_CGS_REFINE_IFNEEDED = eKSPGMRESCGSRefinementType(1)
    KSPGMRESCGSRefinementType, parameter :: KSP_GMRES_CGS_REFINE_ALWAYS = eKSPGMRESCGSRefinementType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_GMRES_CGS_REFINE_NEVER
!DEC$ ATTRIBUTES DLLEXPORT::KSP_GMRES_CGS_REFINE_IFNEEDED
!DEC$ ATTRIBUTES DLLEXPORT::KSP_GMRES_CGS_REFINE_ALWAYS
#endif

  type eKSPNormType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPNormType

  KSPNormType, parameter :: PETSC_NULL_KSPNORMTYPE = eKSPNormType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPNORMTYPE
#endif
    KSPNormType, parameter :: KSP_NORM_DEFAULT = eKSPNormType(-1)
    KSPNormType, parameter :: KSP_NORM_NONE = eKSPNormType(0)
    KSPNormType, parameter :: KSP_NORM_PRECONDITIONED = eKSPNormType(1)
    KSPNormType, parameter :: KSP_NORM_UNPRECONDITIONED = eKSPNormType(2)
    KSPNormType, parameter :: KSP_NORM_NATURAL = eKSPNormType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_NORM_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_NORM_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_NORM_PRECONDITIONED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_NORM_UNPRECONDITIONED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_NORM_NATURAL 
#endif

  type eKSPConvergedReason
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPConvergedReason

  KSPConvergedReason, parameter :: PETSC_NULL_KSPCONVERGEDREASON = eKSPConvergedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPCONVERGEDREASON
#endif
    KSPConvergedReason, parameter :: KSP_CONVERGED_RTOL_NORMAL_DEPRECATED = eKSPConvergedReason(1)
    KSPConvergedReason, parameter :: KSP_CONVERGED_RTOL_NORMAL_EQUATIONS = eKSPConvergedReason(1)
    KSPConvergedReason, parameter :: KSP_CONVERGED_ATOL_NORMAL_DEPRECATED = eKSPConvergedReason(9)
    KSPConvergedReason, parameter :: KSP_CONVERGED_ATOL_NORMAL_EQUATIONS = eKSPConvergedReason(9)
    KSPConvergedReason, parameter :: KSP_CONVERGED_RTOL = eKSPConvergedReason(2)
    KSPConvergedReason, parameter :: KSP_CONVERGED_ATOL = eKSPConvergedReason(3)
    KSPConvergedReason, parameter :: KSP_CONVERGED_ITS = eKSPConvergedReason(4)
    KSPConvergedReason, parameter :: KSP_CONVERGED_NEG_CURVE = eKSPConvergedReason(5)
    KSPConvergedReason, parameter :: KSP_CONVERGED_CG_NEG_CURVE_DEPRECATED = eKSPConvergedReason(5)
    KSPConvergedReason, parameter :: KSP_CONVERGED_CG_CONSTRAINED_DEPRECATED = eKSPConvergedReason(6)
    KSPConvergedReason, parameter :: KSP_CONVERGED_STEP_LENGTH = eKSPConvergedReason(6)
    KSPConvergedReason, parameter :: KSP_CONVERGED_HAPPY_BREAKDOWN = eKSPConvergedReason(7)
    KSPConvergedReason, parameter :: KSP_CONVERGED_USER = eKSPConvergedReason(8)
    KSPConvergedReason, parameter :: KSP_DIVERGED_NULL = eKSPConvergedReason(-2)
    KSPConvergedReason, parameter :: KSP_DIVERGED_ITS = eKSPConvergedReason(-3)
    KSPConvergedReason, parameter :: KSP_DIVERGED_DTOL = eKSPConvergedReason(-4)
    KSPConvergedReason, parameter :: KSP_DIVERGED_BREAKDOWN = eKSPConvergedReason(-5)
    KSPConvergedReason, parameter :: KSP_DIVERGED_BREAKDOWN_BICG = eKSPConvergedReason(-6)
    KSPConvergedReason, parameter :: KSP_DIVERGED_NONSYMMETRIC = eKSPConvergedReason(-7)
    KSPConvergedReason, parameter :: KSP_DIVERGED_INDEFINITE_PC = eKSPConvergedReason(-8)
    KSPConvergedReason, parameter :: KSP_DIVERGED_NANORINF = eKSPConvergedReason(-9)
    KSPConvergedReason, parameter :: KSP_DIVERGED_INDEFINITE_MAT = eKSPConvergedReason(-10)
    KSPConvergedReason, parameter :: KSP_DIVERGED_PC_FAILED = eKSPConvergedReason(-11)
    KSPConvergedReason, parameter :: KSP_DIVERGED_PCSETUP_FAILED_DEPRECATED = eKSPConvergedReason(-11)
    KSPConvergedReason, parameter :: KSP_DIVERGED_USER = eKSPConvergedReason(-12)
    KSPConvergedReason, parameter :: KSP_CONVERGED_ITERATING = eKSPConvergedReason(0)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_RTOL_NORMAL_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_RTOL_NORMAL_EQUATIONS 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_ATOL_NORMAL_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_ATOL_NORMAL_EQUATIONS 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_RTOL 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_ATOL 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_ITS 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_NEG_CURVE 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_CG_NEG_CURVE_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_CG_CONSTRAINED_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_STEP_LENGTH 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_HAPPY_BREAKDOWN 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_NULL 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_ITS 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_DTOL 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_BREAKDOWN 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_BREAKDOWN_BICG 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_NONSYMMETRIC 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_INDEFINITE_PC 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_NANORINF 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_INDEFINITE_MAT 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_PC_FAILED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_PCSETUP_FAILED_DEPRECATED 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_DIVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CONVERGED_ITERATING 
#endif

  type eKSPCGType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eKSPCGType

  KSPCGType, parameter :: PETSC_NULL_KSPCGTYPE = eKSPCGType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_KSPCGTYPE
#endif
    KSPCGType, parameter :: KSP_CG_SYMMETRIC = eKSPCGType(0)
    KSPCGType, parameter :: KSP_CG_HERMITIAN = eKSPCGType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CG_SYMMETRIC 
!DEC$ ATTRIBUTES DLLEXPORT::KSP_CG_HERMITIAN 
#endif

  type eMatSchurComplementAinvType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eMatSchurComplementAinvType

  MatSchurComplementAinvType, parameter :: PETSC_NULL_MATSCHURCOMPLEMENTAINVTYPE = eMatSchurComplementAinvType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_MATSCHURCOMPLEMENTAINVTYPE
#endif
    MatSchurComplementAinvType, parameter :: MAT_SCHUR_COMPLEMENT_AINV_DIAG = eMatSchurComplementAinvType(0)
    MatSchurComplementAinvType, parameter :: MAT_SCHUR_COMPLEMENT_AINV_LUMP = eMatSchurComplementAinvType(1)
    MatSchurComplementAinvType, parameter :: MAT_SCHUR_COMPLEMENT_AINV_BLOCK_DIAG = eMatSchurComplementAinvType(2)
    MatSchurComplementAinvType, parameter :: MAT_SCHUR_COMPLEMENT_AINV_FULL = eMatSchurComplementAinvType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::MAT_SCHUR_COMPLEMENT_AINV_DIAG
!DEC$ ATTRIBUTES DLLEXPORT::MAT_SCHUR_COMPLEMENT_AINV_LUMP
!DEC$ ATTRIBUTES DLLEXPORT::MAT_SCHUR_COMPLEMENT_AINV_BLOCK_DIAG
!DEC$ ATTRIBUTES DLLEXPORT::MAT_SCHUR_COMPLEMENT_AINV_FULL
#endif

  type eMatLMVMMultAlgorithm
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eMatLMVMMultAlgorithm

  MatLMVMMultAlgorithm, parameter :: PETSC_NULL_MATLMVMMULTALGORITHM = eMatLMVMMultAlgorithm(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_MATLMVMMULTALGORITHM
#endif
    MatLMVMMultAlgorithm, parameter :: MAT_LMVM_MULT_RECURSIVE = eMatLMVMMultAlgorithm(0)
    MatLMVMMultAlgorithm, parameter :: MAT_LMVM_MULT_DENSE = eMatLMVMMultAlgorithm(1)
    MatLMVMMultAlgorithm, parameter :: MAT_LMVM_MULT_COMPACT_DENSE = eMatLMVMMultAlgorithm(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_MULT_RECURSIVE
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_MULT_DENSE
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_MULT_COMPACT_DENSE
#endif

  type eMatLMVMSymBroydenScaleType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eMatLMVMSymBroydenScaleType

  MatLMVMSymBroydenScaleType, parameter :: PETSC_NULL_MATLMVMSYMBROYDENSCALETYPE = eMatLMVMSymBroydenScaleType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_MATLMVMSYMBROYDENSCALETYPE
#endif
    MatLMVMSymBroydenScaleType, parameter :: MAT_LMVM_SYMBROYDEN_SCALE_NONE = eMatLMVMSymBroydenScaleType(0)
    MatLMVMSymBroydenScaleType, parameter :: MAT_LMVM_SYMBROYDEN_SCALE_SCALAR = eMatLMVMSymBroydenScaleType(1)
    MatLMVMSymBroydenScaleType, parameter :: MAT_LMVM_SYMBROYDEN_SCALE_DIAGONAL = eMatLMVMSymBroydenScaleType(2)
    MatLMVMSymBroydenScaleType, parameter :: MAT_LMVM_SYMBROYDEN_SCALE_USER = eMatLMVMSymBroydenScaleType(3)
    MatLMVMSymBroydenScaleType, parameter :: MAT_LMVM_SYMBROYDEN_SCALE_DECIDE = eMatLMVMSymBroydenScaleType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_SYMBROYDEN_SCALE_NONE 
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_SYMBROYDEN_SCALE_SCALAR 
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_SYMBROYDEN_SCALE_DIAGONAL 
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_SYMBROYDEN_SCALE_USER 
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_SYMBROYDEN_SCALE_DECIDE 
#endif

  type eMatLMVMDenseType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type eMatLMVMDenseType

  MatLMVMDenseType, parameter :: PETSC_NULL_MATLMVMDENSETYPE = eMatLMVMDenseType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_MATLMVMDENSETYPE
#endif
    MatLMVMDenseType, parameter :: MAT_LMVM_DENSE_REORDER = eMatLMVMDenseType(0)
    MatLMVMDenseType, parameter :: MAT_LMVM_DENSE_INPLACE = eMatLMVMDenseType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_DENSE_REORDER
!DEC$ ATTRIBUTES DLLEXPORT::MAT_LMVM_DENSE_INPLACE
#endif

  CHARACTER(LEN=*), PARAMETER :: KSPRICHARDSON = 'richardson'
  CHARACTER(LEN=*), PARAMETER :: KSPCHEBYSHEV = 'chebyshev'
  CHARACTER(LEN=*), PARAMETER :: KSPCG = 'cg'
  CHARACTER(LEN=*), PARAMETER :: KSPGROPPCG = 'groppcg'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPECG = 'pipecg'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPECGRR = 'pipecgrr'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPELCG = 'pipelcg'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPEPRCG = 'pipeprcg'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPECG2 = 'pipecg2'
  CHARACTER(LEN=*), PARAMETER :: KSPCGNE = 'cgne'
  CHARACTER(LEN=*), PARAMETER :: KSPNASH = 'nash'
  CHARACTER(LEN=*), PARAMETER :: KSPSTCG = 'stcg'
  CHARACTER(LEN=*), PARAMETER :: KSPGLTR = 'gltr'
  CHARACTER(LEN=*), PARAMETER :: KSPCGNASH = 'PETSC_DEPRECATED_MACRO(3,'
  CHARACTER(LEN=*), PARAMETER :: KSPCGSTCG = 'PETSC_DEPRECATED_MACRO(3,'
  CHARACTER(LEN=*), PARAMETER :: KSPCGGLTR = 'PETSC_DEPRECATED_MACRO(3,'
  CHARACTER(LEN=*), PARAMETER :: KSPFCG = 'fcg'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPEFCG = 'pipefcg'
  CHARACTER(LEN=*), PARAMETER :: KSPGMRES = 'gmres'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPEFGMRES = 'pipefgmres'
  CHARACTER(LEN=*), PARAMETER :: KSPFGMRES = 'fgmres'
  CHARACTER(LEN=*), PARAMETER :: KSPLGMRES = 'lgmres'
  CHARACTER(LEN=*), PARAMETER :: KSPDGMRES = 'dgmres'
  CHARACTER(LEN=*), PARAMETER :: KSPPGMRES = 'pgmres'
  CHARACTER(LEN=*), PARAMETER :: KSPTCQMR = 'tcqmr'
  CHARACTER(LEN=*), PARAMETER :: KSPBCGS = 'bcgs'
  CHARACTER(LEN=*), PARAMETER :: KSPIBCGS = 'ibcgs'
  CHARACTER(LEN=*), PARAMETER :: KSPQMRCGS = 'qmrcgs'
  CHARACTER(LEN=*), PARAMETER :: KSPFBCGS = 'fbcgs'
  CHARACTER(LEN=*), PARAMETER :: KSPFBCGSR = 'fbcgsr'
  CHARACTER(LEN=*), PARAMETER :: KSPBCGSL = 'bcgsl'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPEBCGS = 'pipebcgs'
  CHARACTER(LEN=*), PARAMETER :: KSPCGS = 'cgs'
  CHARACTER(LEN=*), PARAMETER :: KSPTFQMR = 'tfqmr'
  CHARACTER(LEN=*), PARAMETER :: KSPCR = 'cr'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPECR = 'pipecr'
  CHARACTER(LEN=*), PARAMETER :: KSPLSQR = 'lsqr'
  CHARACTER(LEN=*), PARAMETER :: KSPPREONLY = 'preonly'
  CHARACTER(LEN=*), PARAMETER :: KSPNONE = 'none'
  CHARACTER(LEN=*), PARAMETER :: KSPQCG = 'qcg'
  CHARACTER(LEN=*), PARAMETER :: KSPBICG = 'bicg'
  CHARACTER(LEN=*), PARAMETER :: KSPMINRES = 'minres'
  CHARACTER(LEN=*), PARAMETER :: KSPSYMMLQ = 'symmlq'
  CHARACTER(LEN=*), PARAMETER :: KSPLCD = 'lcd'
  CHARACTER(LEN=*), PARAMETER :: KSPPYTHON = 'python'
  CHARACTER(LEN=*), PARAMETER :: KSPGCR = 'gcr'
  CHARACTER(LEN=*), PARAMETER :: KSPPIPEGCR = 'pipegcr'
  CHARACTER(LEN=*), PARAMETER :: KSPTSIRM = 'tsirm'
  CHARACTER(LEN=*), PARAMETER :: KSPCGLS = 'cgls'
  CHARACTER(LEN=*), PARAMETER :: KSPFETIDP = 'fetidp'
  CHARACTER(LEN=*), PARAMETER :: KSPHPDDM = 'hpddm'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSPRICHARDSON
!DEC$ ATTRIBUTES DLLEXPORT::KSPCHEBYSHEV
!DEC$ ATTRIBUTES DLLEXPORT::KSPCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPGROPPCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPECG
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPECGRR
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPELCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPEPRCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPECG2
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGNE
!DEC$ ATTRIBUTES DLLEXPORT::KSPNASH
!DEC$ ATTRIBUTES DLLEXPORT::KSPSTCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPGLTR
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGNASH
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGSTCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGGLTR
!DEC$ ATTRIBUTES DLLEXPORT::KSPFCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPEFCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPEFGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPFGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPLGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPDGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPPGMRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPTCQMR
!DEC$ ATTRIBUTES DLLEXPORT::KSPBCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPIBCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPQMRCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPFBCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPFBCGSR
!DEC$ ATTRIBUTES DLLEXPORT::KSPBCGSL
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPEBCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGS
!DEC$ ATTRIBUTES DLLEXPORT::KSPTFQMR
!DEC$ ATTRIBUTES DLLEXPORT::KSPCR
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPECR
!DEC$ ATTRIBUTES DLLEXPORT::KSPLSQR
!DEC$ ATTRIBUTES DLLEXPORT::KSPPREONLY
!DEC$ ATTRIBUTES DLLEXPORT::KSPNONE
!DEC$ ATTRIBUTES DLLEXPORT::KSPQCG
!DEC$ ATTRIBUTES DLLEXPORT::KSPBICG
!DEC$ ATTRIBUTES DLLEXPORT::KSPMINRES
!DEC$ ATTRIBUTES DLLEXPORT::KSPSYMMLQ
!DEC$ ATTRIBUTES DLLEXPORT::KSPLCD
!DEC$ ATTRIBUTES DLLEXPORT::KSPPYTHON
!DEC$ ATTRIBUTES DLLEXPORT::KSPGCR
!DEC$ ATTRIBUTES DLLEXPORT::KSPPIPEGCR
!DEC$ ATTRIBUTES DLLEXPORT::KSPTSIRM
!DEC$ ATTRIBUTES DLLEXPORT::KSPCGLS
!DEC$ ATTRIBUTES DLLEXPORT::KSPFETIDP
!DEC$ ATTRIBUTES DLLEXPORT::KSPHPDDM
#endif

  CHARACTER(LEN=*), PARAMETER :: KSPGUESSFISCHER = 'fischer'
  CHARACTER(LEN=*), PARAMETER :: KSPGUESSPOD = 'pod'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::KSPGUESSFISCHER
!DEC$ ATTRIBUTES DLLEXPORT::KSPGUESSPOD
#endif

