#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchmgsetreuseinterpolation_ PCHMGSETREUSEINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchmgsetreuseinterpolation_ pchmgsetreuseinterpolation
#endif
PETSC_EXTERN void pchmgsetreuseinterpolation_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCHMGSetReuseInterpolation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchmgsetusesubspacecoarsening_ PCHMGSETUSESUBSPACECOARSENING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchmgsetusesubspacecoarsening_ pchmgsetusesubspacecoarsening
#endif
PETSC_EXTERN void pchmgsetusesubspacecoarsening_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCHMGSetUseSubspaceCoarsening(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchmgsetinnerpctype_ PCHMGSETINNERPCTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchmgsetinnerpctype_ pchmgsetinnerpctype
#endif
PETSC_EXTERN void pchmgsetinnerpctype_(PC *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCHMGSetInnerPCType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchmgsetcoarseningcomponent_ PCHMGSETCOARSENINGCOMPONENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchmgsetcoarseningcomponent_ pchmgsetcoarseningcomponent
#endif
PETSC_EXTERN void pchmgsetcoarseningcomponent_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCHMGSetCoarseningComponent(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pchmgusematmaij_ PCHMGUSEMATMAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pchmgusematmaij_ pchmgusematmaij
#endif
PETSC_EXTERN void pchmgusematmaij_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCHMGUseMatMAIJ(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
