#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgalerkinsetrestriction_ PCGALERKINSETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgalerkinsetrestriction_ pcgalerkinsetrestriction
#endif
PETSC_EXTERN void pcgalerkinsetrestriction_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCGalerkinSetRestriction(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgalerkinsetinterpolation_ PCGALERKINSETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgalerkinsetinterpolation_ pcgalerkinsetinterpolation
#endif
PETSC_EXTERN void pcgalerkinsetinterpolation_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCGalerkinSetInterpolation(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgalerkingetksp_ PCGALERKINGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgalerkingetksp_ pcgalerkingetksp
#endif
PETSC_EXTERN void pcgalerkingetksp_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCGalerkinGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
