#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmglobaltolocalsolve_ DMGLOBALTOLOCALSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmglobaltolocalsolve_ dmglobaltolocalsolve
#endif
PETSC_EXTERN void dmglobaltolocalsolve_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMGlobalToLocalSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptinterpolator_ DMADAPTINTERPOLATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptinterpolator_ dmadaptinterpolator
#endif
PETSC_EXTERN void dmadaptinterpolator_(DM *a, DM *b, Mat *c, KSP *d, Mat *e, Mat *f, Mat *g, void *h, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMAdaptInterpolator(*a, *b, *c, *d, *e, *f, g, h);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcheckinterpolator_ DMCHECKINTERPOLATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcheckinterpolator_ dmcheckinterpolator
#endif
PETSC_EXTERN void dmcheckinterpolator_(DM *a, Mat *b, Mat *c, Mat *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = DMCheckInterpolator(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmprojectfields_ DMSWARMPROJECTFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmprojectfields_ dmswarmprojectfields
#endif
PETSC_EXTERN void dmswarmprojectfields_(DM *a, DM *b, PetscInt *c, char d[], Vec e[], ScatterMode *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_d = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMSwarmProjectFields(*a, *b, *c, (const char **)&c_d, e, *f);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)d, c_d, l_d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmprojectgradientfields_ DMSWARMPROJECTGRADIENTFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmprojectgradientfields_ dmswarmprojectgradientfields
#endif
PETSC_EXTERN void dmswarmprojectgradientfields_(DM *a, DM *b, PetscInt *c, char d[], Vec e[], ScatterMode *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_d = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMSwarmProjectGradientFields(*a, *b, *c, (const char **)&c_d, e, *f);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)d, c_d, l_d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmremap_ DMSWARMREMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmremap_ dmswarmremap
#endif
PETSC_EXTERN void dmswarmremap_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmRemap(*a);
  if (*ierr) return;
}
