#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionersettype_ PETSCPARTITIONERSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionersettype_ petscpartitionersettype
#endif
PETSC_EXTERN void petscpartitionersettype_(PetscPartitioner *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscPartitionerSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionergettype_ PETSCPARTITIONERGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionergettype_ petscpartitionergettype
#endif
PETSC_EXTERN void petscpartitionergettype_(PetscPartitioner *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscPartitionerGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerviewfromoptions_ PETSCPARTITIONERVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerviewfromoptions_ petscpartitionerviewfromoptions
#endif
PETSC_EXTERN void petscpartitionerviewfromoptions_(PetscPartitioner *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscPartitionerViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerview_ PETSCPARTITIONERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerview_ petscpartitionerview
#endif
PETSC_EXTERN void petscpartitionerview_(PetscPartitioner *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscPartitionerView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionersetfromoptions_ PETSCPARTITIONERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionersetfromoptions_ petscpartitionersetfromoptions
#endif
PETSC_EXTERN void petscpartitionersetfromoptions_(PetscPartitioner *a, PetscErrorCode *ierr)
{
  *ierr = PetscPartitionerSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionersetup_ PETSCPARTITIONERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionersetup_ petscpartitionersetup
#endif
PETSC_EXTERN void petscpartitionersetup_(PetscPartitioner *a, PetscErrorCode *ierr)
{
  *ierr = PetscPartitionerSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerreset_ PETSCPARTITIONERRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerreset_ petscpartitionerreset
#endif
PETSC_EXTERN void petscpartitionerreset_(PetscPartitioner *a, PetscErrorCode *ierr)
{
  *ierr = PetscPartitionerReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerdestroy_ PETSCPARTITIONERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerdestroy_ petscpartitionerdestroy
#endif
PETSC_EXTERN void petscpartitionerdestroy_(PetscPartitioner *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscPartitionerDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerpartition_ PETSCPARTITIONERPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerpartition_ petscpartitionerpartition
#endif
PETSC_EXTERN void petscpartitionerpartition_(PetscPartitioner *a, PetscInt *b, PetscInt *c, PetscInt d[], PetscInt e[], PetscSection *f, PetscSection *g, PetscSection *h, PetscSection *i, IS *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(j);
  *ierr = PetscPartitionerPartition(*a, *b, *c, d, e, *f, *g, *h, *i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionercreate_ PETSCPARTITIONERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionercreate_ petscpartitionercreate
#endif
PETSC_EXTERN void petscpartitionercreate_(MPI_Fint *a, PetscPartitioner *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscPartitionerCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
