#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagcreateisfromstencils_ DMSTAGCREATEISFROMSTENCILS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagcreateisfromstencils_ dmstagcreateisfromstencils
#endif
PETSC_EXTERN void dmstagcreateisfromstencils_(DM *a, PetscInt *b, DMStagStencil c[], IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMStagCreateISFromStencils(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstaggetlocationdof_ DMSTAGGETLOCATIONDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstaggetlocationdof_ dmstaggetlocationdof
#endif
PETSC_EXTERN void dmstaggetlocationdof_(DM *a, DMStagStencilLocation *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMStagGetLocationDOF(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagmatgetvaluesstencil_ DMSTAGMATGETVALUESSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagmatgetvaluesstencil_ dmstagmatgetvaluesstencil
#endif
PETSC_EXTERN void dmstagmatgetvaluesstencil_(DM *a, Mat *b, PetscInt *c, const DMStagStencil *d, PetscInt *e, const DMStagStencil *f, PetscScalar *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  *ierr = DMStagMatGetValuesStencil(*a, *b, *c, d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagmatsetvaluesstencil_ DMSTAGMATSETVALUESSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagmatsetvaluesstencil_ dmstagmatsetvaluesstencil
#endif
PETSC_EXTERN void dmstagmatsetvaluesstencil_(DM *a, Mat *b, PetscInt *c, const DMStagStencil *d, PetscInt *e, const DMStagStencil *f, const PetscScalar *g, InsertMode *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  *ierr = DMStagMatSetValuesStencil(*a, *b, *c, d, *e, f, g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagstenciltoindexlocal_ DMSTAGSTENCILTOINDEXLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagstenciltoindexlocal_ dmstagstenciltoindexlocal
#endif
PETSC_EXTERN void dmstagstenciltoindexlocal_(DM *a, PetscInt *b, PetscInt *c, const DMStagStencil *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMStagStencilToIndexLocal(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecgetvaluesstencil_ DMSTAGVECGETVALUESSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecgetvaluesstencil_ dmstagvecgetvaluesstencil
#endif
PETSC_EXTERN void dmstagvecgetvaluesstencil_(DM *a, Vec *b, PetscInt *c, const DMStagStencil *d, PetscScalar *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = DMStagVecGetValuesStencil(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagvecsetvaluesstencil_ DMSTAGVECSETVALUESSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagvecsetvaluesstencil_ dmstagvecsetvaluesstencil
#endif
PETSC_EXTERN void dmstagvecsetvaluesstencil_(DM *a, Vec *b, PetscInt *c, const DMStagStencil *d, const PetscScalar *e, InsertMode *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = DMStagVecSetValuesStencil(*a, *b, *c, d, e, *f);
  if (*ierr) return;
}
