#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagcreate1d_ DMSTAGCREATE1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagcreate1d_ dmstagcreate1d
#endif
PETSC_EXTERN void dmstagcreate1d_(MPI_Fint *a, DMBoundaryType *b, PetscInt *c, PetscInt *d, PetscInt *e, DMStagStencilType *f, PetscInt *g, const PetscInt h[], DM *i, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLOBJECT(i);
  *ierr = DMStagCreate1d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
