#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpreallocateoperator_ DMPLEXPREALLOCATEOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpreallocateoperator_ dmplexpreallocateoperator
#endif
PETSC_EXTERN void dmplexpreallocateoperator_(DM *a, PetscInt *b, PetscInt c[], PetscInt d[], PetscInt e[], PetscInt f[], Mat *g, PetscBool *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = DMPlexPreallocateOperator(*a, *b, c, d, e, f, *g, *h ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
