#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestregistertype_ DMFORESTREGISTERTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestregistertype_ dmforestregistertype
#endif
PETSC_EXTERN void dmforestregistertype_(char *a, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = DMForestRegisterType(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmisforest_ DMISFOREST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmisforest_ dmisforest
#endif
PETSC_EXTERN void dmisforest_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMIsForest(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforesttemplate_ DMFORESTTEMPLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforesttemplate_ dmforesttemplate
#endif
PETSC_EXTERN void dmforesttemplate_(DM *a, MPI_Fint *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMForestTemplate(*a, MPI_Comm_f2c(*(b)), c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsettopology_ DMFORESTSETTOPOLOGY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsettopology_ dmforestsettopology
#endif
PETSC_EXTERN void dmforestsettopology_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMForestSetTopology(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgettopology_ DMFORESTGETTOPOLOGY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgettopology_ dmforestgettopology
#endif
PETSC_EXTERN void dmforestgettopology_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMForestGetTopology(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetbasedm_ DMFORESTSETBASEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetbasedm_ dmforestsetbasedm
#endif
PETSC_EXTERN void dmforestsetbasedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetBaseDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetbasedm_ DMFORESTGETBASEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetbasedm_ dmforestgetbasedm
#endif
PETSC_EXTERN void dmforestgetbasedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMForestGetBaseDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadaptivityforest_ DMFORESTSETADAPTIVITYFOREST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadaptivityforest_ dmforestsetadaptivityforest
#endif
PETSC_EXTERN void dmforestsetadaptivityforest_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetAdaptivityForest(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivityforest_ DMFORESTGETADAPTIVITYFOREST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivityforest_ dmforestgetadaptivityforest
#endif
PETSC_EXTERN void dmforestgetadaptivityforest_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMForestGetAdaptivityForest(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadaptivitypurpose_ DMFORESTSETADAPTIVITYPURPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadaptivitypurpose_ dmforestsetadaptivitypurpose
#endif
PETSC_EXTERN void dmforestsetadaptivitypurpose_(DM *a, DMAdaptFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetAdaptivityPurpose(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivitypurpose_ DMFORESTGETADAPTIVITYPURPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivitypurpose_ dmforestgetadaptivitypurpose
#endif
PETSC_EXTERN void dmforestgetadaptivitypurpose_(DM *a, DMAdaptFlag *b, PetscErrorCode *ierr)
{
  *ierr = DMForestGetAdaptivityPurpose(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadjacencydimension_ DMFORESTSETADJACENCYDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadjacencydimension_ dmforestsetadjacencydimension
#endif
PETSC_EXTERN void dmforestsetadjacencydimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetAdjacencyDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadjacencycodimension_ DMFORESTSETADJACENCYCODIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadjacencycodimension_ dmforestsetadjacencycodimension
#endif
PETSC_EXTERN void dmforestsetadjacencycodimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetAdjacencyCodimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadjacencydimension_ DMFORESTGETADJACENCYDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadjacencydimension_ dmforestgetadjacencydimension
#endif
PETSC_EXTERN void dmforestgetadjacencydimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetAdjacencyDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadjacencycodimension_ DMFORESTGETADJACENCYCODIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadjacencycodimension_ dmforestgetadjacencycodimension
#endif
PETSC_EXTERN void dmforestgetadjacencycodimension_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetAdjacencyCodimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetpartitionoverlap_ DMFORESTSETPARTITIONOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetpartitionoverlap_ dmforestsetpartitionoverlap
#endif
PETSC_EXTERN void dmforestsetpartitionoverlap_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetPartitionOverlap(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetpartitionoverlap_ DMFORESTGETPARTITIONOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetpartitionoverlap_ dmforestgetpartitionoverlap
#endif
PETSC_EXTERN void dmforestgetpartitionoverlap_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetPartitionOverlap(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetminimumrefinement_ DMFORESTSETMINIMUMREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetminimumrefinement_ dmforestsetminimumrefinement
#endif
PETSC_EXTERN void dmforestsetminimumrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetMinimumRefinement(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetminimumrefinement_ DMFORESTGETMINIMUMREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetminimumrefinement_ dmforestgetminimumrefinement
#endif
PETSC_EXTERN void dmforestgetminimumrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetMinimumRefinement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetinitialrefinement_ DMFORESTSETINITIALREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetinitialrefinement_ dmforestsetinitialrefinement
#endif
PETSC_EXTERN void dmforestsetinitialrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetInitialRefinement(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetinitialrefinement_ DMFORESTGETINITIALREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetinitialrefinement_ dmforestgetinitialrefinement
#endif
PETSC_EXTERN void dmforestgetinitialrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetInitialRefinement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetmaximumrefinement_ DMFORESTSETMAXIMUMREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetmaximumrefinement_ dmforestsetmaximumrefinement
#endif
PETSC_EXTERN void dmforestsetmaximumrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetMaximumRefinement(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetmaximumrefinement_ DMFORESTGETMAXIMUMREFINEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetmaximumrefinement_ dmforestgetmaximumrefinement
#endif
PETSC_EXTERN void dmforestgetmaximumrefinement_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetMaximumRefinement(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadaptivitystrategy_ DMFORESTSETADAPTIVITYSTRATEGY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadaptivitystrategy_ dmforestsetadaptivitystrategy
#endif
PETSC_EXTERN void dmforestsetadaptivitystrategy_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMForestSetAdaptivityStrategy(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivitystrategy_ DMFORESTGETADAPTIVITYSTRATEGY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivitystrategy_ dmforestgetadaptivitystrategy
#endif
PETSC_EXTERN void dmforestgetadaptivitystrategy_(DM *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMForestGetAdaptivityStrategy(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivitysuccess_ DMFORESTGETADAPTIVITYSUCCESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivitysuccess_ dmforestgetadaptivitysuccess
#endif
PETSC_EXTERN void dmforestgetadaptivitysuccess_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMForestGetAdaptivitySuccess(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetcomputeadaptivitysf_ DMFORESTSETCOMPUTEADAPTIVITYSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetcomputeadaptivitysf_ dmforestsetcomputeadaptivitysf
#endif
PETSC_EXTERN void dmforestsetcomputeadaptivitysf_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetComputeAdaptivitySF(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforesttransfervec_ DMFORESTTRANSFERVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforesttransfervec_ dmforesttransfervec
#endif
PETSC_EXTERN void dmforesttransfervec_(DM *a, Vec *b, DM *c, Vec *d, PetscBool *e, PetscReal *f, PetscErrorCode *ierr)
{
  *ierr = DMForestTransferVec(*a, *b, *c, *d, *e ? PETSC_TRUE : PETSC_FALSE, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforesttransfervecfrombase_ DMFORESTTRANSFERVECFROMBASE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforesttransfervecfrombase_ dmforesttransfervecfrombase
#endif
PETSC_EXTERN void dmforesttransfervecfrombase_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMForestTransferVecFromBase(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetcomputeadaptivitysf_ DMFORESTGETCOMPUTEADAPTIVITYSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetcomputeadaptivitysf_ dmforestgetcomputeadaptivitysf
#endif
PETSC_EXTERN void dmforestgetcomputeadaptivitysf_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMForestGetComputeAdaptivitySF(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivitysf_ DMFORESTGETADAPTIVITYSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivitysf_ dmforestgetadaptivitysf
#endif
PETSC_EXTERN void dmforestgetadaptivitysf_(DM *a, PetscSF *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMForestGetAdaptivitySF(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetgradefactor_ DMFORESTSETGRADEFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetgradefactor_ dmforestsetgradefactor
#endif
PETSC_EXTERN void dmforestsetgradefactor_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetGradeFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetgradefactor_ DMFORESTGETGRADEFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetgradefactor_ dmforestgetgradefactor
#endif
PETSC_EXTERN void dmforestgetgradefactor_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMForestGetGradeFactor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetcellweightfactor_ DMFORESTSETCELLWEIGHTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetcellweightfactor_ dmforestsetcellweightfactor
#endif
PETSC_EXTERN void dmforestsetcellweightfactor_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetCellWeightFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetcellweightfactor_ DMFORESTGETCELLWEIGHTFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetcellweightfactor_ dmforestgetcellweightfactor
#endif
PETSC_EXTERN void dmforestgetcellweightfactor_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMForestGetCellWeightFactor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetcellchart_ DMFORESTGETCELLCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetcellchart_ dmforestgetcellchart
#endif
PETSC_EXTERN void dmforestgetcellchart_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMForestGetCellChart(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetcellsf_ DMFORESTGETCELLSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetcellsf_ dmforestgetcellsf
#endif
PETSC_EXTERN void dmforestgetcellsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMForestGetCellSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetadaptivitylabel_ DMFORESTSETADAPTIVITYLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetadaptivitylabel_ dmforestsetadaptivitylabel
#endif
PETSC_EXTERN void dmforestsetadaptivitylabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetAdaptivityLabel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetadaptivitylabel_ DMFORESTGETADAPTIVITYLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetadaptivitylabel_ dmforestgetadaptivitylabel
#endif
PETSC_EXTERN void dmforestgetadaptivitylabel_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMForestGetAdaptivityLabel(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetcellweights_ DMFORESTSETCELLWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetcellweights_ dmforestsetcellweights
#endif
PETSC_EXTERN void dmforestsetcellweights_(DM *a, PetscReal b[], PetscCopyMode *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMForestSetCellWeights(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestsetweightcapacity_ DMFORESTSETWEIGHTCAPACITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestsetweightcapacity_ dmforestsetweightcapacity
#endif
PETSC_EXTERN void dmforestsetweightcapacity_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMForestSetWeightCapacity(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmforest.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmforestgetweightcapacity_ DMFORESTGETWEIGHTCAPACITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmforestgetweightcapacity_ dmforestgetweightcapacity
#endif
PETSC_EXTERN void dmforestgetweightcapacity_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMForestGetWeightCapacity(*a, b);
  if (*ierr) return;
}
