#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegeomgetpoint_ PETSCFEGEOMGETPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegeomgetpoint_ petscfegeomgetpoint
#endif
PETSC_EXTERN void petscfegeomgetpoint_(PetscFEGeom **a, PetscInt *b, PetscInt *c, const PetscReal d[], PetscFEGeom **e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = PetscFEGeomGetPoint(*a, *b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegeomgetcellpoint_ PETSCFEGEOMGETCELLPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegeomgetcellpoint_ petscfegeomgetcellpoint
#endif
PETSC_EXTERN void petscfegeomgetcellpoint_(PetscFEGeom **a, PetscInt *b, PetscInt *c, PetscFEGeom **d, PetscErrorCode *ierr)
{
  *ierr = PetscFEGeomGetCellPoint(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfegeomcomplete_ PETSCFEGEOMCOMPLETE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfegeomcomplete_ petscfegeomcomplete
#endif
PETSC_EXTERN void petscfegeomcomplete_(PetscFEGeom **a, PetscErrorCode *ierr)
{
  *ierr = PetscFEGeomComplete(*a);
  if (*ierr) return;
}
