#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegetcontinuity_ PETSCDUALSPACELAGRANGEGETCONTINUITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegetcontinuity_ petscdualspacelagrangegetcontinuity
#endif
PETSC_EXTERN void petscdualspacelagrangegetcontinuity_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceLagrangeGetContinuity(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesetcontinuity_ PETSCDUALSPACELAGRANGESETCONTINUITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesetcontinuity_ petscdualspacelagrangesetcontinuity
#endif
PETSC_EXTERN void petscdualspacelagrangesetcontinuity_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetContinuity(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegettensor_ PETSCDUALSPACELAGRANGEGETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegettensor_ petscdualspacelagrangegettensor
#endif
PETSC_EXTERN void petscdualspacelagrangegettensor_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceLagrangeGetTensor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesettensor_ PETSCDUALSPACELAGRANGESETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesettensor_ petscdualspacelagrangesettensor
#endif
PETSC_EXTERN void petscdualspacelagrangesettensor_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetTensor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegettrimmed_ PETSCDUALSPACELAGRANGEGETTRIMMED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegettrimmed_ petscdualspacelagrangegettrimmed
#endif
PETSC_EXTERN void petscdualspacelagrangegettrimmed_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceLagrangeGetTrimmed(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesettrimmed_ PETSCDUALSPACELAGRANGESETTRIMMED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesettrimmed_ petscdualspacelagrangesettrimmed
#endif
PETSC_EXTERN void petscdualspacelagrangesettrimmed_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetTrimmed(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegetnodetype_ PETSCDUALSPACELAGRANGEGETNODETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegetnodetype_ petscdualspacelagrangegetnodetype
#endif
PETSC_EXTERN void petscdualspacelagrangegetnodetype_(PetscDualSpace *a, PetscDTNodeType *b, PetscBool *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscDualSpaceLagrangeGetNodeType(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesetnodetype_ PETSCDUALSPACELAGRANGESETNODETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesetnodetype_ petscdualspacelagrangesetnodetype
#endif
PETSC_EXTERN void petscdualspacelagrangesetnodetype_(PetscDualSpace *a, PetscDTNodeType *b, PetscBool *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetNodeType(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegetusemoments_ PETSCDUALSPACELAGRANGEGETUSEMOMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegetusemoments_ petscdualspacelagrangegetusemoments
#endif
PETSC_EXTERN void petscdualspacelagrangegetusemoments_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceLagrangeGetUseMoments(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesetusemoments_ PETSCDUALSPACELAGRANGESETUSEMOMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesetusemoments_ petscdualspacelagrangesetusemoments
#endif
PETSC_EXTERN void petscdualspacelagrangesetusemoments_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetUseMoments(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangegetmomentorder_ PETSCDUALSPACELAGRANGEGETMOMENTORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangegetmomentorder_ petscdualspacelagrangegetmomentorder
#endif
PETSC_EXTERN void petscdualspacelagrangegetmomentorder_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceLagrangeGetMomentOrder(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacelagrangesetmomentorder_ PETSCDUALSPACELAGRANGESETMOMENTORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacelagrangesetmomentorder_ petscdualspacelagrangesetmomentorder
#endif
PETSC_EXTERN void petscdualspacelagrangesetmomentorder_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceLagrangeSetMomentOrder(*a, *b);
  if (*ierr) return;
}
