#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvaluessection_ VECSETVALUESSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvaluessection_ vecsetvaluessection
#endif
PETSC_EXTERN void vecsetvaluessection_(Vec *a, PetscSection *b, PetscInt *c, const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecSetValuesSection(*a, *b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionvecview_ PETSCSECTIONVECVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionvecview_ petscsectionvecview
#endif
PETSC_EXTERN void petscsectionvecview_(PetscSection *a, Vec *b, PetscViewer *c, PetscErrorCode *ierr)
{
  PetscViewer v_c = PetscPatchDefaultViewers(c);
  *ierr = PetscSectionVecView(*a, *b, v_c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionvecnorm_ PETSCSECTIONVECNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionvecnorm_ petscsectionvecnorm
#endif
PETSC_EXTERN void petscsectionvecnorm_(PetscSection *a, PetscSection *b, Vec *c, NormType *d, PetscReal e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  *ierr = PetscSectionVecNorm(*a, *b, *c, *d, e);
  if (*ierr) return;
}
