#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclayouthdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5readsizes_ PETSCVIEWERHDF5READSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5readsizes_ petscviewerhdf5readsizes
#endif
PETSC_EXTERN void petscviewerhdf5readsizes_(PetscViewer *a, char b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscViewerHDF5ReadSizes(v_a, c_b, c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
