#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetfromoptions_ TSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetfromoptions_ tssetfromoptions
#endif
PETSC_EXTERN void tssetfromoptions_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgettrajectory_ TSGETTRAJECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgettrajectory_ tsgettrajectory
#endif
PETSC_EXTERN void tsgettrajectory_(TS *a, TSTrajectory *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetTrajectory(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetsavetrajectory_ TSSETSAVETRAJECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetsavetrajectory_ tssetsavetrajectory
#endif
PETSC_EXTERN void tssetsavetrajectory_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSSetSaveTrajectory(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsresettrajectory_ TSRESETTRAJECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsresettrajectory_ tsresettrajectory
#endif
PETSC_EXTERN void tsresettrajectory_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSResetTrajectory(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsremovetrajectory_ TSREMOVETRAJECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsremovetrajectory_ tsremovetrajectory
#endif
PETSC_EXTERN void tsremovetrajectory_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSRemoveTrajectory(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhsjacobian_ TSCOMPUTERHSJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhsjacobian_ tscomputerhsjacobian
#endif
PETSC_EXTERN void tscomputerhsjacobian_(TS *a, PetscReal *b, Vec *c, Mat *d, Mat *e, PetscErrorCode *ierr)
{
  *ierr = TSComputeRHSJacobian(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhsfunction_ TSCOMPUTERHSFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhsfunction_ tscomputerhsfunction
#endif
PETSC_EXTERN void tscomputerhsfunction_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = TSComputeRHSFunction(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputesolutionfunction_ TSCOMPUTESOLUTIONFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputesolutionfunction_ tscomputesolutionfunction
#endif
PETSC_EXTERN void tscomputesolutionfunction_(TS *a, PetscReal *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSComputeSolutionFunction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeforcingfunction_ TSCOMPUTEFORCINGFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeforcingfunction_ tscomputeforcingfunction
#endif
PETSC_EXTERN void tscomputeforcingfunction_(TS *a, PetscReal *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSComputeForcingFunction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeifunction_ TSCOMPUTEIFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeifunction_ tscomputeifunction
#endif
PETSC_EXTERN void tscomputeifunction_(TS *a, PetscReal *b, Vec *c, Vec *d, Vec *e, PetscBool *f, PetscErrorCode *ierr)
{
  *ierr = TSComputeIFunction(*a, *b, *c, *d, *e, *f ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeijacobian_ TSCOMPUTEIJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeijacobian_ tscomputeijacobian
#endif
PETSC_EXTERN void tscomputeijacobian_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, Mat *g, PetscBool *h, PetscErrorCode *ierr)
{
  *ierr = TSComputeIJacobian(*a, *b, *c, *d, *e, *f, *g, *h ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhsjacobiansetreuse_ TSRHSJACOBIANSETREUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhsjacobiansetreuse_ tsrhsjacobiansetreuse
#endif
PETSC_EXTERN void tsrhsjacobiansetreuse_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSRHSJacobianSetReuse(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputei2function_ TSCOMPUTEI2FUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputei2function_ tscomputei2function
#endif
PETSC_EXTERN void tscomputei2function_(TS *a, PetscReal *b, Vec *c, Vec *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = TSComputeI2Function(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputei2jacobian_ TSCOMPUTEI2JACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputei2jacobian_ tscomputei2jacobian
#endif
PETSC_EXTERN void tscomputei2jacobian_(TS *a, PetscReal *b, Vec *c, Vec *d, Vec *e, PetscReal *f, PetscReal *g, Mat *h, Mat *i, PetscErrorCode *ierr)
{
  *ierr = TSComputeI2Jacobian(*a, *b, *c, *d, *e, *f, *g, *h, *i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputetransientvariable_ TSCOMPUTETRANSIENTVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputetransientvariable_ tscomputetransientvariable
#endif
PETSC_EXTERN void tscomputetransientvariable_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSComputeTransientVariable(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tshastransientvariable_ TSHASTRANSIENTVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tshastransientvariable_ tshastransientvariable
#endif
PETSC_EXTERN void tshastransientvariable_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSHasTransientVariable(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define ts2setsolution_ TS2SETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define ts2setsolution_ ts2setsolution
#endif
PETSC_EXTERN void ts2setsolution_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TS2SetSolution(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define ts2getsolution_ TS2GETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define ts2getsolution_ ts2getsolution
#endif
PETSC_EXTERN void ts2getsolution_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TS2GetSolution(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsload_ TSLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsload_ tsload
#endif
PETSC_EXTERN void tsload_(TS *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsviewfromoptions_ TSVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsviewfromoptions_ tsviewfromoptions
#endif
PETSC_EXTERN void tsviewfromoptions_(TS *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = TSViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsview_ TSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsview_ tsview
#endif
PETSC_EXTERN void tsview_(TS *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetapplicationcontext_ TSSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetapplicationcontext_ tssetapplicationcontext
#endif
PETSC_EXTERN void tssetapplicationcontext_(TS *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = TSSetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetapplicationcontext_ TSGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetapplicationcontext_ tsgetapplicationcontext
#endif
PETSC_EXTERN void tsgetapplicationcontext_(TS *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TSGetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetstepnumber_ TSGETSTEPNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetstepnumber_ tsgetstepnumber
#endif
PETSC_EXTERN void tsgetstepnumber_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetStepNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetstepnumber_ TSSETSTEPNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetstepnumber_ tssetstepnumber
#endif
PETSC_EXTERN void tssetstepnumber_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSetStepNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssettimestep_ TSSETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssettimestep_ tssettimestep
#endif
PETSC_EXTERN void tssettimestep_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSSetTimeStep(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetexactfinaltime_ TSSETEXACTFINALTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetexactfinaltime_ tssetexactfinaltime
#endif
PETSC_EXTERN void tssetexactfinaltime_(TS *a, TSExactFinalTimeOption *b, PetscErrorCode *ierr)
{
  *ierr = TSSetExactFinalTime(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetexactfinaltime_ TSGETEXACTFINALTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetexactfinaltime_ tsgetexactfinaltime
#endif
PETSC_EXTERN void tsgetexactfinaltime_(TS *a, TSExactFinalTimeOption *b, PetscErrorCode *ierr)
{
  *ierr = TSGetExactFinalTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgettimestep_ TSGETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgettimestep_ tsgettimestep
#endif
PETSC_EXTERN void tsgettimestep_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetTimeStep(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsolution_ TSGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsolution_ tsgetsolution
#endif
PETSC_EXTERN void tsgetsolution_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetSolution(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsolutioncomponents_ TSGETSOLUTIONCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsolutioncomponents_ tsgetsolutioncomponents
#endif
PETSC_EXTERN void tsgetsolutioncomponents_(TS *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSGetSolutionComponents(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetauxsolution_ TSGETAUXSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetauxsolution_ tsgetauxsolution
#endif
PETSC_EXTERN void tsgetauxsolution_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetAuxSolution(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgettimeerror_ TSGETTIMEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgettimeerror_ tsgettimeerror
#endif
PETSC_EXTERN void tsgettimeerror_(TS *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSGetTimeError(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssettimeerror_ TSSETTIMEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssettimeerror_ tssettimeerror
#endif
PETSC_EXTERN void tssettimeerror_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TSSetTimeError(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetproblemtype_ TSSETPROBLEMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetproblemtype_ tssetproblemtype
#endif
PETSC_EXTERN void tssetproblemtype_(TS *a, TSProblemType *b, PetscErrorCode *ierr)
{
  *ierr = TSSetProblemType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetproblemtype_ TSGETPROBLEMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetproblemtype_ tsgetproblemtype
#endif
PETSC_EXTERN void tsgetproblemtype_(TS *a, TSProblemType *b, PetscErrorCode *ierr)
{
  *ierr = TSGetProblemType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetup_ TSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetup_ tssetup
#endif
PETSC_EXTERN void tssetup_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsreset_ TSRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsreset_ tsreset
#endif
PETSC_EXTERN void tsreset_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsdestroy_ TSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsdestroy_ tsdestroy
#endif
PETSC_EXTERN void tsdestroy_(TS *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsnes_ TSGETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsnes_ tsgetsnes
#endif
PETSC_EXTERN void tsgetsnes_(TS *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetSNES(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetsnes_ TSSETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetsnes_ tssetsnes
#endif
PETSC_EXTERN void tssetsnes_(TS *a, SNES *b, PetscErrorCode *ierr)
{
  *ierr = TSSetSNES(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetksp_ TSGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetksp_ tsgetksp
#endif
PETSC_EXTERN void tsgetksp_(TS *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetmaxsteps_ TSSETMAXSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetmaxsteps_ tssetmaxsteps
#endif
PETSC_EXTERN void tssetmaxsteps_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSetMaxSteps(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetmaxsteps_ TSGETMAXSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetmaxsteps_ tsgetmaxsteps
#endif
PETSC_EXTERN void tsgetmaxsteps_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetMaxSteps(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetrunsteps_ TSSETRUNSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetrunsteps_ tssetrunsteps
#endif
PETSC_EXTERN void tssetrunsteps_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSetRunSteps(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetrunsteps_ TSGETRUNSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetrunsteps_ tsgetrunsteps
#endif
PETSC_EXTERN void tsgetrunsteps_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetRunSteps(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetmaxtime_ TSSETMAXTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetmaxtime_ tssetmaxtime
#endif
PETSC_EXTERN void tssetmaxtime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSSetMaxTime(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetmaxtime_ TSGETMAXTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetmaxtime_ tsgetmaxtime
#endif
PETSC_EXTERN void tsgetmaxtime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetMaxTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetsolution_ TSSETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetsolution_ tssetsolution
#endif
PETSC_EXTERN void tssetsolution_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TSSetSolution(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsprestep_ TSPRESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsprestep_ tsprestep
#endif
PETSC_EXTERN void tsprestep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSPreStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsprestage_ TSPRESTAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsprestage_ tsprestage
#endif
PETSC_EXTERN void tsprestage_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSPreStage(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspoststage_ TSPOSTSTAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspoststage_ tspoststage
#endif
PETSC_EXTERN void tspoststage_(TS *a, PetscReal *b, PetscInt *c, Vec d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  *ierr = TSPostStage(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspostevaluate_ TSPOSTEVALUATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspostevaluate_ tspostevaluate
#endif
PETSC_EXTERN void tspostevaluate_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSPostEvaluate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspoststep_ TSPOSTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspoststep_ tspoststep
#endif
PETSC_EXTERN void tspoststep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSPostStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsinterpolate_ TSINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsinterpolate_ tsinterpolate
#endif
PETSC_EXTERN void tsinterpolate_(TS *a, PetscReal *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSInterpolate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsstep_ TSSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsstep_ tsstep
#endif
PETSC_EXTERN void tsstep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsevaluatewlte_ TSEVALUATEWLTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsevaluatewlte_ tsevaluatewlte
#endif
PETSC_EXTERN void tsevaluatewlte_(TS *a, NormType *b, PetscInt *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  *ierr = TSEvaluateWLTE(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsevaluatestep_ TSEVALUATESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsevaluatestep_ tsevaluatestep
#endif
PETSC_EXTERN void tsevaluatestep_(TS *a, PetscInt *b, Vec *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = TSEvaluateStep(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeinitialcondition_ TSCOMPUTEINITIALCONDITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeinitialcondition_ tscomputeinitialcondition
#endif
PETSC_EXTERN void tscomputeinitialcondition_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TSComputeInitialCondition(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeexacterror_ TSCOMPUTEEXACTERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeexacterror_ tscomputeexacterror
#endif
PETSC_EXTERN void tscomputeexacterror_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSComputeExactError(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsresizeregistervec_ TSRESIZEREGISTERVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsresizeregistervec_ tsresizeregistervec
#endif
PETSC_EXTERN void tsresizeregistervec_(TS *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSResizeRegisterVec(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsresizeretrievevec_ TSRESIZERETRIEVEVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsresizeretrievevec_ tsresizeretrievevec
#endif
PETSC_EXTERN void tsresizeretrievevec_(TS *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSResizeRetrieveVec(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsresize_ TSRESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsresize_ tsresize
#endif
PETSC_EXTERN void tsresize_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSResize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssolve_ TSSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssolve_ tssolve
#endif
PETSC_EXTERN void tssolve_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TSSolve(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgettime_ TSGETTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgettime_ tsgettime
#endif
PETSC_EXTERN void tsgettime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetprevtime_ TSGETPREVTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetprevtime_ tsgetprevtime
#endif
PETSC_EXTERN void tsgetprevtime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetPrevTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssettime_ TSSETTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssettime_ tssettime
#endif
PETSC_EXTERN void tssettime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSSetTime(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetoptionsprefix_ TSSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetoptionsprefix_ tssetoptionsprefix
#endif
PETSC_EXTERN void tssetoptionsprefix_(TS *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsappendoptionsprefix_ TSAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsappendoptionsprefix_ tsappendoptionsprefix
#endif
PETSC_EXTERN void tsappendoptionsprefix_(TS *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetoptionsprefix_ TSGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetoptionsprefix_ tsgetoptionsprefix
#endif
PETSC_EXTERN void tsgetoptionsprefix_(TS *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetdm_ TSSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetdm_ tssetdm
#endif
PETSC_EXTERN void tssetdm_(TS *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = TSSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetdm_ TSGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetdm_ tsgetdm
#endif
PETSC_EXTERN void tsgetdm_(TS *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhsfunctionlinear_ TSCOMPUTERHSFUNCTIONLINEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhsfunctionlinear_ tscomputerhsfunctionlinear
#endif
PETSC_EXTERN void tscomputerhsfunctionlinear_(TS *a, PetscReal *b, Vec *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSComputeRHSFunctionLinear(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhsjacobianconstant_ TSCOMPUTERHSJACOBIANCONSTANT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhsjacobianconstant_ tscomputerhsjacobianconstant
#endif
PETSC_EXTERN void tscomputerhsjacobianconstant_(TS *a, PetscReal *b, Vec *c, Mat *d, Mat *e, void *f, PetscErrorCode *ierr)
{
  *ierr = TSComputeRHSJacobianConstant(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeifunctionlinear_ TSCOMPUTEIFUNCTIONLINEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeifunctionlinear_ tscomputeifunctionlinear
#endif
PETSC_EXTERN void tscomputeifunctionlinear_(TS *a, PetscReal *b, Vec *c, Vec *d, Vec *e, void *f, PetscErrorCode *ierr)
{
  *ierr = TSComputeIFunctionLinear(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeijacobianconstant_ TSCOMPUTEIJACOBIANCONSTANT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeijacobianconstant_ tscomputeijacobianconstant
#endif
PETSC_EXTERN void tscomputeijacobianconstant_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, Mat *g, void *h, PetscErrorCode *ierr)
{
  *ierr = TSComputeIJacobianConstant(*a, *b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetequationtype_ TSGETEQUATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetequationtype_ tsgetequationtype
#endif
PETSC_EXTERN void tsgetequationtype_(TS *a, TSEquationType *b, PetscErrorCode *ierr)
{
  *ierr = TSGetEquationType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetequationtype_ TSSETEQUATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetequationtype_ tssetequationtype
#endif
PETSC_EXTERN void tssetequationtype_(TS *a, TSEquationType *b, PetscErrorCode *ierr)
{
  *ierr = TSSetEquationType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetconvergedreason_ TSGETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetconvergedreason_ tsgetconvergedreason
#endif
PETSC_EXTERN void tsgetconvergedreason_(TS *a, TSConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = TSGetConvergedReason(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetconvergedreason_ TSSETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetconvergedreason_ tssetconvergedreason
#endif
PETSC_EXTERN void tssetconvergedreason_(TS *a, TSConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = TSSetConvergedReason(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsolvetime_ TSGETSOLVETIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsolvetime_ tsgetsolvetime
#endif
PETSC_EXTERN void tsgetsolvetime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetSolveTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsnesiterations_ TSGETSNESITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsnesiterations_ tsgetsnesiterations
#endif
PETSC_EXTERN void tsgetsnesiterations_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetSNESIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetkspiterations_ TSGETKSPITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetkspiterations_ tsgetkspiterations
#endif
PETSC_EXTERN void tsgetkspiterations_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetKSPIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsteprejections_ TSGETSTEPREJECTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsteprejections_ tsgetsteprejections
#endif
PETSC_EXTERN void tsgetsteprejections_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetStepRejections(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsnesfailures_ TSGETSNESFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsnesfailures_ tsgetsnesfailures
#endif
PETSC_EXTERN void tsgetsnesfailures_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSGetSNESFailures(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetmaxsteprejections_ TSSETMAXSTEPREJECTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetmaxsteprejections_ tssetmaxsteprejections
#endif
PETSC_EXTERN void tssetmaxsteprejections_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSetMaxStepRejections(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetmaxsnesfailures_ TSSETMAXSNESFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetmaxsnesfailures_ tssetmaxsnesfailures
#endif
PETSC_EXTERN void tssetmaxsnesfailures_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSSetMaxSNESFailures(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsseterrorifstepfails_ TSSETERRORIFSTEPFAILS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsseterrorifstepfails_ tsseterrorifstepfails
#endif
PETSC_EXTERN void tsseterrorifstepfails_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSSetErrorIfStepFails(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetadapt_ TSGETADAPT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetadapt_ tsgetadapt
#endif
PETSC_EXTERN void tsgetadapt_(TS *a, TSAdapt *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetAdapt(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssettolerances_ TSSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssettolerances_ tssettolerances
#endif
PETSC_EXTERN void tssettolerances_(TS *a, PetscReal *b, Vec *c, PetscReal *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = TSSetTolerances(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgettolerances_ TSGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgettolerances_ tsgettolerances
#endif
PETSC_EXTERN void tsgettolerances_(TS *a, PetscReal *b, Vec *c, PetscReal *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = TSGetTolerances(*a, b, c, d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tserrorweightednorm_ TSERRORWEIGHTEDNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tserrorweightednorm_ tserrorweightednorm
#endif
PETSC_EXTERN void tserrorweightednorm_(TS *a, Vec *b, Vec *c, NormType *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = TSErrorWeightedNorm(*a, *b, *c, *d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tserrorweightedenorm_ TSERRORWEIGHTEDENORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tserrorweightedenorm_ tserrorweightedenorm
#endif
PETSC_EXTERN void tserrorweightedenorm_(TS *a, Vec *b, Vec *c, Vec *d, NormType *e, PetscReal *f, PetscReal *g, PetscReal *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  *ierr = TSErrorWeightedENorm(*a, *b, *c, *d, *e, f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetcfltimelocal_ TSSETCFLTIMELOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetcfltimelocal_ tssetcfltimelocal
#endif
PETSC_EXTERN void tssetcfltimelocal_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSSetCFLTimeLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetcfltime_ TSGETCFLTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetcfltime_ tsgetcfltime
#endif
PETSC_EXTERN void tsgetcfltime_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSGetCFLTime(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsvisetvariablebounds_ TSVISETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsvisetvariablebounds_ tsvisetvariablebounds
#endif
PETSC_EXTERN void tsvisetvariablebounds_(TS *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TSVISetVariableBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputelinearstability_ TSCOMPUTELINEARSTABILITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputelinearstability_ tscomputelinearstability
#endif
PETSC_EXTERN void tscomputelinearstability_(TS *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = TSComputeLinearStability(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrestartstep_ TSRESTARTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrestartstep_ tsrestartstep
#endif
PETSC_EXTERN void tsrestartstep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSRestartStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrollback_ TSROLLBACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrollback_ tsrollback
#endif
PETSC_EXTERN void tsrollback_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSRollBack(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetsteprollback_ TSGETSTEPROLLBACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetsteprollback_ tsgetsteprollback
#endif
PETSC_EXTERN void tsgetsteprollback_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSGetStepRollBack(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetstepresize_ TSGETSTEPRESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetstepresize_ tsgetstepresize
#endif
PETSC_EXTERN void tsgetstepresize_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSGetStepResize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeijacobiandefaultcolor_ TSCOMPUTEIJACOBIANDEFAULTCOLOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeijacobiandefaultcolor_ tscomputeijacobiandefaultcolor
#endif
PETSC_EXTERN void tscomputeijacobiandefaultcolor_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, Mat *g, void *h, PetscErrorCode *ierr)
{
  *ierr = TSComputeIJacobianDefaultColor(*a, *b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsfunctiondomainerror_ TSFUNCTIONDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsfunctiondomainerror_ tsfunctiondomainerror
#endif
PETSC_EXTERN void tsfunctiondomainerror_(TS *a, PetscReal *b, Vec *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = TSFunctionDomainError(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsclone_ TSCLONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsclone_ tsclone
#endif
PETSC_EXTERN void tsclone_(TS *a, TS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSClone(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhsjacobiantest_ TSRHSJACOBIANTEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhsjacobiantest_ tsrhsjacobiantest
#endif
PETSC_EXTERN void tsrhsjacobiantest_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSRHSJacobianTest(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsrhsjacobiantesttranspose_ TSRHSJACOBIANTESTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsrhsjacobiantesttranspose_ tsrhsjacobiantesttranspose
#endif
PETSC_EXTERN void tsrhsjacobiantesttranspose_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSRHSJacobianTestTranspose(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetusesplitrhsfunction_ TSSETUSESPLITRHSFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetusesplitrhsfunction_ tssetusesplitrhsfunction
#endif
PETSC_EXTERN void tssetusesplitrhsfunction_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSSetUseSplitRHSFunction(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetusesplitrhsfunction_ TSGETUSESPLITRHSFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetusesplitrhsfunction_ tsgetusesplitrhsfunction
#endif
PETSC_EXTERN void tsgetusesplitrhsfunction_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSGetUseSplitRHSFunction(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetmatstructure_ TSSETMATSTRUCTURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetmatstructure_ tssetmatstructure
#endif
PETSC_EXTERN void tssetmatstructure_(TS *a, MatStructure *b, PetscErrorCode *ierr)
{
  *ierr = TSSetMatStructure(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetevaluationtimes_ TSSETEVALUATIONTIMES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetevaluationtimes_ tssetevaluationtimes
#endif
PETSC_EXTERN void tssetevaluationtimes_(TS *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TSSetEvaluationTimes(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssettimespan_ TSSETTIMESPAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssettimespan_ tssettimespan
#endif
PETSC_EXTERN void tssettimespan_(TS *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TSSetTimeSpan(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tspruneijacobiancolor_ TSPRUNEIJACOBIANCOLOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tspruneijacobiancolor_ tspruneijacobiancolor
#endif
PETSC_EXTERN void tspruneijacobiancolor_(TS *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = TSPruneIJacobianColor(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snestsformfunction_ SNESTSFORMFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snestsformfunction_ snestsformfunction
#endif
PETSC_EXTERN void snestsformfunction_(SNES *a, Vec *b, Vec *c, void *d, PetscErrorCode *ierr)
{
  *ierr = SNESTSFormFunction(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snestsformjacobian_ SNESTSFORMJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snestsformjacobian_ snestsformjacobian
#endif
PETSC_EXTERN void snestsformjacobian_(SNES *a, Vec *b, Mat *c, Mat *d, void *e, PetscErrorCode *ierr)
{
  *ierr = SNESTSFormJacobian(*a, *b, *c, *d, e);
  if (*ierr) return;
}
