#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsthetagettheta_ TSTHETAGETTHETA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsthetagettheta_ tsthetagettheta
#endif
PETSC_EXTERN void tsthetagettheta_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TSThetaGetTheta(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsthetasettheta_ TSTHETASETTHETA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsthetasettheta_ tsthetasettheta
#endif
PETSC_EXTERN void tsthetasettheta_(TS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TSThetaSetTheta(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsthetagetendpoint_ TSTHETAGETENDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsthetagetendpoint_ tsthetagetendpoint
#endif
PETSC_EXTERN void tsthetagetendpoint_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSThetaGetEndpoint(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsthetasetendpoint_ TSTHETASETENDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsthetasetendpoint_ tsthetasetendpoint
#endif
PETSC_EXTERN void tsthetasetendpoint_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSThetaSetEndpoint(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
