#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsccharacteristic.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define characteristicdestroy_ CHARACTERISTICDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define characteristicdestroy_ characteristicdestroy
#endif
PETSC_EXTERN void characteristicdestroy_(Characteristic *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = CharacteristicDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsccharacteristic.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define characteristiccreate_ CHARACTERISTICCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define characteristiccreate_ characteristiccreate
#endif
PETSC_EXTERN void characteristiccreate_(MPI_Fint *a, Characteristic *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = CharacteristicCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsccharacteristic.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define characteristicsettype_ CHARACTERISTICSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define characteristicsettype_ characteristicsettype
#endif
PETSC_EXTERN void characteristicsettype_(Characteristic *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = CharacteristicSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsccharacteristic.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define characteristicsetup_ CHARACTERISTICSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define characteristicsetup_ characteristicsetup
#endif
PETSC_EXTERN void characteristicsetup_(Characteristic *a, PetscErrorCode *ierr)
{
  *ierr = CharacteristicSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsccharacteristic.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define characteristicsolve_ CHARACTERISTICSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define characteristicsolve_ characteristicsolve
#endif
PETSC_EXTERN void characteristicsolve_(Characteristic *a, PetscReal *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = CharacteristicSolve(*a, *b, *c);
  if (*ierr) return;
}
