#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdamapcoordstoperiodicdomain_ DMDAMAPCOORDSTOPERIODICDOMAIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdamapcoordstoperiodicdomain_ dmdamapcoordstoperiodicdomain
#endif
PETSC_EXTERN void dmdamapcoordstoperiodicdomain_(DM *a, PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMDAMapCoordsToPeriodicDomain(*a, b, c);
  if (*ierr) return;
}
