#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgngetdampingvector_ TAOBRGNGETDAMPINGVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgngetdampingvector_ taobrgngetdampingvector
#endif
PETSC_EXTERN void taobrgngetdampingvector_(Tao *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoBRGNGetDampingVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgngetregularizationtype_ TAOBRGNGETREGULARIZATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgngetregularizationtype_ taobrgngetregularizationtype
#endif
PETSC_EXTERN void taobrgngetregularizationtype_(Tao *a, TaoBRGNRegularizationType *b, PetscErrorCode *ierr)
{
  *ierr = TaoBRGNGetRegularizationType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgnsetregularizationtype_ TAOBRGNSETREGULARIZATIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgnsetregularizationtype_ taobrgnsetregularizationtype
#endif
PETSC_EXTERN void taobrgnsetregularizationtype_(Tao *a, TaoBRGNRegularizationType *b, PetscErrorCode *ierr)
{
  *ierr = TaoBRGNSetRegularizationType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgngetsubsolver_ TAOBRGNGETSUBSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgngetsubsolver_ taobrgngetsubsolver
#endif
PETSC_EXTERN void taobrgngetsubsolver_(Tao *a, Tao *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoBRGNGetSubsolver(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgnsetregularizerweight_ TAOBRGNSETREGULARIZERWEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgnsetregularizerweight_ taobrgnsetregularizerweight
#endif
PETSC_EXTERN void taobrgnsetregularizerweight_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TaoBRGNSetRegularizerWeight(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgnsetl1smoothepsilon_ TAOBRGNSETL1SMOOTHEPSILON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgnsetl1smoothepsilon_ taobrgnsetl1smoothepsilon
#endif
PETSC_EXTERN void taobrgnsetl1smoothepsilon_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TaoBRGNSetL1SmoothEpsilon(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taobrgnsetdictionarymatrix_ TAOBRGNSETDICTIONARYMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taobrgnsetdictionarymatrix_ taobrgnsetdictionarymatrix
#endif
PETSC_EXTERN void taobrgnsetdictionarymatrix_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TaoBRGNSetDictionaryMatrix(*a, *b);
  if (*ierr) return;
}
