#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolmvmrecycle_ TAOLMVMRECYCLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolmvmrecycle_ taolmvmrecycle
#endif
PETSC_EXTERN void taolmvmrecycle_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TaoLMVMRecycle(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolmvmseth0_ TAOLMVMSETH0
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolmvmseth0_ taolmvmseth0
#endif
PETSC_EXTERN void taolmvmseth0_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TaoLMVMSetH0(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolmvmgeth0_ TAOLMVMGETH0
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolmvmgeth0_ taolmvmgeth0
#endif
PETSC_EXTERN void taolmvmgeth0_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoLMVMGetH0(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolmvmgeth0ksp_ TAOLMVMGETH0KSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolmvmgeth0ksp_ taolmvmgeth0ksp
#endif
PETSC_EXTERN void taolmvmgeth0ksp_(Tao *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoLMVMGetH0KSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
