#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetenv_ PETSCOPTIONSGETENV
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetenv_ petscoptionsgetenv
#endif
PETSC_EXTERN void petscoptionsgetenv_(MPI_Fint *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscOptionsGetenv(MPI_Comm_f2c(*(a)), c_b, c, l_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetdisplay_ PETSCSETDISPLAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetdisplay_ petscsetdisplay
#endif
PETSC_EXTERN void petscsetdisplay_(PetscErrorCode *ierr)
{
  *ierr = PetscSetDisplay();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetdisplay_ PETSCGETDISPLAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetdisplay_ petscgetdisplay
#endif
PETSC_EXTERN void petscgetdisplay_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  *ierr = PetscGetDisplay(a, l_a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
