#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsequentialphasebegin_ PETSCSEQUENTIALPHASEBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsequentialphasebegin_ petscsequentialphasebegin
#endif
PETSC_EXTERN void petscsequentialphasebegin_(MPI_Fint *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscSequentialPhaseBegin(MPI_Comm_f2c(*(a)), *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsequentialphaseend_ PETSCSEQUENTIALPHASEEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsequentialphaseend_ petscsequentialphaseend
#endif
PETSC_EXTERN void petscsequentialphaseend_(MPI_Fint *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscSequentialPhaseEnd(MPI_Comm_f2c(*(a)), *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscglobalminmaxint_ PETSCGLOBALMINMAXINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscglobalminmaxint_ petscglobalminmaxint
#endif
PETSC_EXTERN void petscglobalminmaxint_(MPI_Fint *a, const PetscInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscGlobalMinMaxInt(MPI_Comm_f2c(*(a)), b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscglobalminmaxreal_ PETSCGLOBALMINMAXREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscglobalminmaxreal_ petscglobalminmaxreal
#endif
PETSC_EXTERN void petscglobalminmaxreal_(MPI_Fint *a, const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscGlobalMinMaxReal(MPI_Comm_f2c(*(a)), b, c);
  if (*ierr) return;
}
