#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdatatypegetsize_ PETSCDATATYPEGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdatatypegetsize_ petscdatatypegetsize
#endif
PETSC_EXTERN void petscdatatypegetsize_(PetscDataType *a, size_t *b, PetscErrorCode *ierr)
{
  *ierr = PetscDataTypeGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdatatypefromstring_ PETSCDATATYPEFROMSTRING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdatatypefromstring_ petscdatatypefromstring
#endif
PETSC_EXTERN void petscdatatypefromstring_(char a[], PetscDataType *b, PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscDataTypeFromString(c_a, b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
