#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextcreate_ PETSCDEVICECONTEXTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextcreate_ petscdevicecontextcreate
#endif
PETSC_EXTERN void petscdevicecontextcreate_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(a);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDeviceContextCreate(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextdestroy_ PETSCDEVICECONTEXTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextdestroy_ petscdevicecontextdestroy
#endif
PETSC_EXTERN void petscdevicecontextdestroy_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDeviceContextDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsetstreamtype_ PETSCDEVICECONTEXTSETSTREAMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsetstreamtype_ petscdevicecontextsetstreamtype
#endif
PETSC_EXTERN void petscdevicecontextsetstreamtype_(PetscDeviceContext *a, PetscStreamType *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSetStreamType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextgetstreamtype_ PETSCDEVICECONTEXTGETSTREAMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextgetstreamtype_ petscdevicecontextgetstreamtype
#endif
PETSC_EXTERN void petscdevicecontextgetstreamtype_(PetscDeviceContext *a, PetscStreamType *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextGetStreamType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsetdevice_ PETSCDEVICECONTEXTSETDEVICE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsetdevice_ petscdevicecontextsetdevice
#endif
PETSC_EXTERN void petscdevicecontextsetdevice_(PetscDeviceContext *a, PetscDevice *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSetDevice(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextgetdevice_ PETSCDEVICECONTEXTGETDEVICE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextgetdevice_ petscdevicecontextgetdevice
#endif
PETSC_EXTERN void petscdevicecontextgetdevice_(PetscDeviceContext *a, PetscDevice *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDeviceContextGetDevice(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextgetdevicetype_ PETSCDEVICECONTEXTGETDEVICETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextgetdevicetype_ petscdevicecontextgetdevicetype
#endif
PETSC_EXTERN void petscdevicecontextgetdevicetype_(PetscDeviceContext *a, PetscDeviceType *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextGetDeviceType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsetup_ PETSCDEVICECONTEXTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsetup_ petscdevicecontextsetup
#endif
PETSC_EXTERN void petscdevicecontextsetup_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextduplicate_ PETSCDEVICECONTEXTDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextduplicate_ petscdevicecontextduplicate
#endif
PETSC_EXTERN void petscdevicecontextduplicate_(PetscDeviceContext *a, PetscDeviceContext *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDeviceContextDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextqueryidle_ PETSCDEVICECONTEXTQUERYIDLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextqueryidle_ petscdevicecontextqueryidle
#endif
PETSC_EXTERN void petscdevicecontextqueryidle_(PetscDeviceContext *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDeviceContextQueryIdle(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextwaitforcontext_ PETSCDEVICECONTEXTWAITFORCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextwaitforcontext_ petscdevicecontextwaitforcontext
#endif
PETSC_EXTERN void petscdevicecontextwaitforcontext_(PetscDeviceContext *a, PetscDeviceContext *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextWaitForContext(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsynchronize_ PETSCDEVICECONTEXTSYNCHRONIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsynchronize_ petscdevicecontextsynchronize
#endif
PETSC_EXTERN void petscdevicecontextsynchronize_(PetscDeviceContext *a, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSynchronize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextsetfromoptions_ PETSCDEVICECONTEXTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextsetfromoptions_ petscdevicecontextsetfromoptions
#endif
PETSC_EXTERN void petscdevicecontextsetfromoptions_(MPI_Fint *a, PetscDeviceContext *b, PetscErrorCode *ierr)
{
  *ierr = PetscDeviceContextSetFromOptions(MPI_Comm_f2c(*(a)), *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextview_ PETSCDEVICECONTEXTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextview_ petscdevicecontextview
#endif
PETSC_EXTERN void petscdevicecontextview_(PetscDeviceContext *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDeviceContextView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdevice.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdevicecontextviewfromoptions_ PETSCDEVICECONTEXTVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdevicecontextviewfromoptions_ petscdevicecontextviewfromoptions
#endif
PETSC_EXTERN void petscdevicecontextviewfromoptions_(PetscDeviceContext *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscDeviceContextViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
