#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarysetusempiio_ PETSCVIEWERBINARYSETUSEMPIIO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarysetusempiio_ petscviewerbinarysetusempiio
#endif
PETSC_EXTERN void petscviewerbinarysetusempiio_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySetUseMPIIO(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetusempiio_ PETSCVIEWERBINARYGETUSEMPIIO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetusempiio_ petscviewerbinarygetusempiio
#endif
PETSC_EXTERN void petscviewerbinarygetusempiio_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerBinaryGetUseMPIIO(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarysetflowcontrol_ PETSCVIEWERBINARYSETFLOWCONTROL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarysetflowcontrol_ petscviewerbinarysetflowcontrol
#endif
PETSC_EXTERN void petscviewerbinarysetflowcontrol_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySetFlowControl(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetflowcontrol_ PETSCVIEWERBINARYGETFLOWCONTROL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetflowcontrol_ petscviewerbinarygetflowcontrol
#endif
PETSC_EXTERN void petscviewerbinarygetflowcontrol_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerBinaryGetFlowControl(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetdescriptor_ PETSCVIEWERBINARYGETDESCRIPTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetdescriptor_ petscviewerbinarygetdescriptor
#endif
PETSC_EXTERN void petscviewerbinarygetdescriptor_(PetscViewer *a, int *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinaryGetDescriptor(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinaryskipinfo_ PETSCVIEWERBINARYSKIPINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinaryskipinfo_ petscviewerbinaryskipinfo
#endif
PETSC_EXTERN void petscviewerbinaryskipinfo_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySkipInfo(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarysetskipinfo_ PETSCVIEWERBINARYSETSKIPINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarysetskipinfo_ petscviewerbinarysetskipinfo
#endif
PETSC_EXTERN void petscviewerbinarysetskipinfo_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySetSkipInfo(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetskipinfo_ PETSCVIEWERBINARYGETSKIPINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetskipinfo_ petscviewerbinarygetskipinfo
#endif
PETSC_EXTERN void petscviewerbinarygetskipinfo_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerBinaryGetSkipInfo(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarysetskipoptions_ PETSCVIEWERBINARYSETSKIPOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarysetskipoptions_ petscviewerbinarysetskipoptions
#endif
PETSC_EXTERN void petscviewerbinarysetskipoptions_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySetSkipOptions(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetskipoptions_ PETSCVIEWERBINARYGETSKIPOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetskipoptions_ petscviewerbinarygetskipoptions
#endif
PETSC_EXTERN void petscviewerbinarygetskipoptions_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerBinaryGetSkipOptions(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarysetskipheader_ PETSCVIEWERBINARYSETSKIPHEADER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarysetskipheader_ petscviewerbinarysetskipheader
#endif
PETSC_EXTERN void petscviewerbinarysetskipheader_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinarySetSkipHeader(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarygetskipheader_ PETSCVIEWERBINARYGETSKIPHEADER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarygetskipheader_ petscviewerbinarygetskipheader
#endif
PETSC_EXTERN void petscviewerbinarygetskipheader_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerBinaryGetSkipHeader(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinaryopen_ PETSCVIEWERBINARYOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinaryopen_ petscviewerbinaryopen
#endif
PETSC_EXTERN void petscviewerbinaryopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerBinaryOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinaryread_ PETSCVIEWERBINARYREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinaryread_ petscviewerbinaryread
#endif
PETSC_EXTERN void petscviewerbinaryread_(PetscViewer *a, void *b, PetscInt *c, PetscInt *d, PetscDataType *e, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscViewerBinaryRead(v_a, b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarywrite_ PETSCVIEWERBINARYWRITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarywrite_ petscviewerbinarywrite
#endif
PETSC_EXTERN void petscviewerbinarywrite_(PetscViewer *a, const void *b, PetscInt *c, PetscDataType *d, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinaryWrite(v_a, b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinaryreadall_ PETSCVIEWERBINARYREADALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinaryreadall_ petscviewerbinaryreadall
#endif
PETSC_EXTERN void petscviewerbinaryreadall_(PetscViewer *a, void *b, PetscCount *c, PetscCount *d, PetscCount *e, PetscDataType *f, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinaryReadAll(v_a, b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerbinarywriteall_ PETSCVIEWERBINARYWRITEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerbinarywriteall_ petscviewerbinarywriteall
#endif
PETSC_EXTERN void petscviewerbinarywriteall_(PetscViewer *a, const void *b, PetscCount *c, PetscCount *d, PetscCount *e, PetscDataType *f, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerBinaryWriteAll(v_a, b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerfilesetmode_ PETSCVIEWERFILESETMODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerfilesetmode_ petscviewerfilesetmode
#endif
PETSC_EXTERN void petscviewerfilesetmode_(PetscViewer *a, PetscFileMode *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerFileSetMode(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerfilegetmode_ PETSCVIEWERFILEGETMODE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerfilegetmode_ petscviewerfilegetmode
#endif
PETSC_EXTERN void petscviewerfilegetmode_(PetscViewer *a, PetscFileMode *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerFileGetMode(v_a, b);
  if (*ierr) return;
}
