#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgaddcommonpoint_ PETSCDRAWLGADDCOMMONPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgaddcommonpoint_ petscdrawlgaddcommonpoint
#endif
PETSC_EXTERN void petscdrawlgaddcommonpoint_(PetscDrawLG *a, const PetscReal *b, const PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDrawLGAddCommonPoint(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgaddpoint_ PETSCDRAWLGADDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgaddpoint_ petscdrawlgaddpoint
#endif
PETSC_EXTERN void petscdrawlgaddpoint_(PetscDrawLG *a, const PetscReal *b, const PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDrawLGAddPoint(*a, b, c);
  if (*ierr) return;
}
