#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawtriangle_ PETSCDRAWTRIANGLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawtriangle_ petscdrawtriangle
#endif
PETSC_EXTERN void petscdrawtriangle_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, int *h, int *i, int *j, PetscErrorCode *ierr)
{
  *ierr = PetscDrawTriangle(*a, *b, *c, *d, *e, *f, *g, *h, *i, *j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawscalepopup_ PETSCDRAWSCALEPOPUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawscalepopup_ petscdrawscalepopup
#endif
PETSC_EXTERN void petscdrawscalepopup_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawScalePopup(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawtensorcontour_ PETSCDRAWTENSORCONTOUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawtensorcontour_ petscdrawtensorcontour
#endif
PETSC_EXTERN void petscdrawtensorcontour_(PetscDraw *a, int *b, int *c, const PetscReal d[], const PetscReal e[], PetscReal f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscDrawTensorContour(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawtensorcontourpatch_ PETSCDRAWTENSORCONTOURPATCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawtensorcontourpatch_ petscdrawtensorcontourpatch
#endif
PETSC_EXTERN void petscdrawtensorcontourpatch_(PetscDraw *a, int *b, int *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscReal *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(h);
  *ierr = PetscDrawTensorContourPatch(*a, *b, *c, d, e, *f, *g, h);
  if (*ierr) return;
}
