#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvigetactivesetis_ SNESVIGETACTIVESETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvigetactivesetis_ snesvigetactivesetis
#endif
PETSC_EXTERN void snesvigetactivesetis_(SNES *a, Vec *b, Vec *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = SNESVIGetActiveSetIS(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvicomputeinactivesetfnorm_ SNESVICOMPUTEINACTIVESETFNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvicomputeinactivesetfnorm_ snesvicomputeinactivesetfnorm
#endif
PETSC_EXTERN void snesvicomputeinactivesetfnorm_(SNES *a, Vec *b, Vec *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = SNESVIComputeInactiveSetFnorm(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvicomputeinactivesetfty_ SNESVICOMPUTEINACTIVESETFTY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvicomputeinactivesetfty_ snesvicomputeinactivesetfty
#endif
PETSC_EXTERN void snesvicomputeinactivesetfty_(SNES *a, Vec *b, Vec *c, Vec *d, PetscScalar *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = SNESVIComputeInactiveSetFtY(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvisetvariablebounds_ SNESVISETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvisetvariablebounds_ snesvisetvariablebounds
#endif
PETSC_EXTERN void snesvisetvariablebounds_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESVISetVariableBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvigetvariablebounds_ SNESVIGETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvigetvariablebounds_ snesvigetvariablebounds
#endif
PETSC_EXTERN void snesvigetvariablebounds_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESVIGetVariableBounds(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
