#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrsetnormtype_ SNESNEWTONTRSETNORMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrsetnormtype_ snesnewtontrsetnormtype
#endif
PETSC_EXTERN void snesnewtontrsetnormtype_(SNES *a, NormType *b, PetscErrorCode *ierr)
{
  *ierr = SNESNewtonTRSetNormType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrsetqntype_ SNESNEWTONTRSETQNTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrsetqntype_ snesnewtontrsetqntype
#endif
PETSC_EXTERN void snesnewtontrsetqntype_(SNES *a, SNESNewtonTRQNType *b, PetscErrorCode *ierr)
{
  *ierr = SNESNewtonTRSetQNType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrsetfallbacktype_ SNESNEWTONTRSETFALLBACKTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrsetfallbacktype_ snesnewtontrsetfallbacktype
#endif
PETSC_EXTERN void snesnewtontrsetfallbacktype_(SNES *a, SNESNewtonTRFallbackType *b, PetscErrorCode *ierr)
{
  *ierr = SNESNewtonTRSetFallbackType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrprecheck_ SNESNEWTONTRPRECHECK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrprecheck_ snesnewtontrprecheck
#endif
PETSC_EXTERN void snesnewtontrprecheck_(SNES *a, Vec *b, Vec *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = SNESNewtonTRPreCheck(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrpostcheck_ SNESNEWTONTRPOSTCHECK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrpostcheck_ snesnewtontrpostcheck
#endif
PETSC_EXTERN void snesnewtontrpostcheck_(SNES *a, Vec *b, Vec *c, Vec *d, PetscBool *e, PetscBool *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = SNESNewtonTRPostCheck(*a, *b, *c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrsettolerances_ SNESNEWTONTRSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrsettolerances_ snesnewtontrsettolerances
#endif
PETSC_EXTERN void snesnewtontrsettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = SNESNewtonTRSetTolerances(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrgettolerances_ SNESNEWTONTRGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrgettolerances_ snesnewtontrgettolerances
#endif
PETSC_EXTERN void snesnewtontrgettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = SNESNewtonTRGetTolerances(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrsetupdateparameters_ SNESNEWTONTRSETUPDATEPARAMETERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrsetupdateparameters_ snesnewtontrsetupdateparameters
#endif
PETSC_EXTERN void snesnewtontrsetupdateparameters_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  *ierr = SNESNewtonTRSetUpdateParameters(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesnewtontrgetupdateparameters_ SNESNEWTONTRGETUPDATEPARAMETERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesnewtontrgetupdateparameters_ snesnewtontrgetupdateparameters
#endif
PETSC_EXTERN void snesnewtontrgetupdateparameters_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = SNESNewtonTRGetUpdateParameters(*a, b, c, d, e, f);
  if (*ierr) return;
}
