#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassettype_ SNESFASSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassettype_ snesfassettype
#endif
PETSC_EXTERN void snesfassettype_(SNES *a, SNESFASType *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgettype_ SNESFASGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgettype_ snesfasgettype
#endif
PETSC_EXTERN void snesfasgettype_(SNES *a, SNESFASType *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetlevels_ SNESFASGETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetlevels_ snesfasgetlevels
#endif
PETSC_EXTERN void snesfasgetlevels_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESFASGetLevels(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetcyclesnes_ SNESFASGETCYCLESNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetcyclesnes_ snesfasgetcyclesnes
#endif
PETSC_EXTERN void snesfasgetcyclesnes_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetCycleSNES(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetnumbersmoothup_ SNESFASSETNUMBERSMOOTHUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetnumbersmoothup_ snesfassetnumbersmoothup
#endif
PETSC_EXTERN void snesfassetnumbersmoothup_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetNumberSmoothUp(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetnumbersmoothdown_ SNESFASSETNUMBERSMOOTHDOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetnumbersmoothdown_ snesfassetnumbersmoothdown
#endif
PETSC_EXTERN void snesfassetnumbersmoothdown_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetNumberSmoothDown(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetcontinuation_ SNESFASSETCONTINUATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetcontinuation_ snesfassetcontinuation
#endif
PETSC_EXTERN void snesfassetcontinuation_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetContinuation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetcycles_ SNESFASSETCYCLES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetcycles_ snesfassetcycles
#endif
PETSC_EXTERN void snesfassetcycles_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetCycles(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetmonitor_ SNESFASSETMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetmonitor_ snesfassetmonitor
#endif
PETSC_EXTERN void snesfassetmonitor_(SNES *a, PetscViewerAndFormat **b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetMonitor(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetlog_ SNESFASSETLOG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetlog_ snesfassetlog
#endif
PETSC_EXTERN void snesfassetlog_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetLog(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclesetcycles_ SNESFASCYCLESETCYCLES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclesetcycles_ snesfascyclesetcycles
#endif
PETSC_EXTERN void snesfascyclesetcycles_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASCycleSetCycles(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetsmoother_ SNESFASCYCLEGETSMOOTHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetsmoother_ snesfascyclegetsmoother
#endif
PETSC_EXTERN void snesfascyclegetsmoother_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetSmoother(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetsmootherup_ SNESFASCYCLEGETSMOOTHERUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetsmootherup_ snesfascyclegetsmootherup
#endif
PETSC_EXTERN void snesfascyclegetsmootherup_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetSmootherUp(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetsmootherdown_ SNESFASCYCLEGETSMOOTHERDOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetsmootherdown_ snesfascyclegetsmootherdown
#endif
PETSC_EXTERN void snesfascyclegetsmootherdown_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetSmootherDown(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetcorrection_ SNESFASCYCLEGETCORRECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetcorrection_ snesfascyclegetcorrection
#endif
PETSC_EXTERN void snesfascyclegetcorrection_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetCorrection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetinterpolation_ SNESFASCYCLEGETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetinterpolation_ snesfascyclegetinterpolation
#endif
PETSC_EXTERN void snesfascyclegetinterpolation_(SNES *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetInterpolation(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetrestriction_ SNESFASCYCLEGETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetrestriction_ snesfascyclegetrestriction
#endif
PETSC_EXTERN void snesfascyclegetrestriction_(SNES *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetRestriction(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetinjection_ SNESFASCYCLEGETINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetinjection_ snesfascyclegetinjection
#endif
PETSC_EXTERN void snesfascyclegetinjection_(SNES *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetInjection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascyclegetrscale_ SNESFASCYCLEGETRSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascyclegetrscale_ snesfascyclegetrscale
#endif
PETSC_EXTERN void snesfascyclegetrscale_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASCycleGetRScale(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfascycleisfine_ SNESFASCYCLEISFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfascycleisfine_ snesfascycleisfine
#endif
PETSC_EXTERN void snesfascycleisfine_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESFASCycleIsFine(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetinterpolation_ SNESFASSETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetinterpolation_ snesfassetinterpolation
#endif
PETSC_EXTERN void snesfassetinterpolation_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetInterpolation(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetinterpolation_ SNESFASGETINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetinterpolation_ snesfasgetinterpolation
#endif
PETSC_EXTERN void snesfasgetinterpolation_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetInterpolation(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetrestriction_ SNESFASSETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetrestriction_ snesfassetrestriction
#endif
PETSC_EXTERN void snesfassetrestriction_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetRestriction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetrestriction_ SNESFASGETRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetrestriction_ snesfasgetrestriction
#endif
PETSC_EXTERN void snesfasgetrestriction_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetRestriction(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetinjection_ SNESFASSETINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetinjection_ snesfassetinjection
#endif
PETSC_EXTERN void snesfassetinjection_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetInjection(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetinjection_ SNESFASGETINJECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetinjection_ snesfasgetinjection
#endif
PETSC_EXTERN void snesfasgetinjection_(SNES *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetInjection(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfassetrscale_ SNESFASSETRSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfassetrscale_ snesfassetrscale
#endif
PETSC_EXTERN void snesfassetrscale_(SNES *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESFASSetRScale(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetsmoother_ SNESFASGETSMOOTHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetsmoother_ snesfasgetsmoother
#endif
PETSC_EXTERN void snesfasgetsmoother_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetSmoother(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetsmootherdown_ SNESFASGETSMOOTHERDOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetsmootherdown_ snesfasgetsmootherdown
#endif
PETSC_EXTERN void snesfasgetsmootherdown_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetSmootherDown(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetsmootherup_ SNESFASGETSMOOTHERUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetsmootherup_ snesfasgetsmootherup
#endif
PETSC_EXTERN void snesfasgetsmootherup_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESFASGetSmootherUp(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasgetcoarsesolve_ SNESFASGETCOARSESOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasgetcoarsesolve_ snesfasgetcoarsesolve
#endif
PETSC_EXTERN void snesfasgetcoarsesolve_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESFASGetCoarseSolve(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasfullsetdownsweep_ SNESFASFULLSETDOWNSWEEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasfullsetdownsweep_ snesfasfullsetdownsweep
#endif
PETSC_EXTERN void snesfasfullsetdownsweep_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASFullSetDownSweep(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasfullsettotal_ SNESFASFULLSETTOTAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasfullsettotal_ snesfasfullsettotal
#endif
PETSC_EXTERN void snesfasfullsettotal_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESFASFullSetTotal(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesfasfullgettotal_ SNESFASFULLGETTOTAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesfasfullgettotal_ snesfasfullgettotal
#endif
PETSC_EXTERN void snesfasfullgettotal_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESFASFullGetTotal(*a, b);
  if (*ierr) return;
}
