#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorlinearsetfitintercept_ PETSCREGRESSORLINEARSETFITINTERCEPT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorlinearsetfitintercept_ petscregressorlinearsetfitintercept
#endif
PETSC_EXTERN void petscregressorlinearsetfitintercept_(PetscRegressor *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorLinearSetFitIntercept(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorlinearsetuseksp_ PETSCREGRESSORLINEARSETUSEKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorlinearsetuseksp_ petscregressorlinearsetuseksp
#endif
PETSC_EXTERN void petscregressorlinearsetuseksp_(PetscRegressor *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorLinearSetUseKSP(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorlineargetksp_ PETSCREGRESSORLINEARGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorlineargetksp_ petscregressorlineargetksp
#endif
PETSC_EXTERN void petscregressorlineargetksp_(PetscRegressor *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscRegressorLinearGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorlinearsettype_ PETSCREGRESSORLINEARSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorlinearsettype_ petscregressorlinearsettype
#endif
PETSC_EXTERN void petscregressorlinearsettype_(PetscRegressor *a, PetscRegressorLinearType *b, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorLinearSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscml.h>
#include <petscregressor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscregressorlineargettype_ PETSCREGRESSORLINEARGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscregressorlineargettype_ petscregressorlineargettype
#endif
PETSC_EXTERN void petscregressorlineargettype_(PetscRegressor *a, PetscRegressorLinearType *b, PetscErrorCode *ierr)
{
  *ierr = PetscRegressorLinearGetType(*a, b);
  if (*ierr) return;
}
