#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspacecreaterigidbody_ MATNULLSPACECREATERIGIDBODY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspacecreaterigidbody_ matnullspacecreaterigidbody
#endif
PETSC_EXTERN void matnullspacecreaterigidbody_(Vec *a, MatNullSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatNullSpaceCreateRigidBody(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspaceview_ MATNULLSPACEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspaceview_ matnullspaceview
#endif
PETSC_EXTERN void matnullspaceview_(MatNullSpace *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatNullSpaceView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspacecreate_ MATNULLSPACECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspacecreate_ matnullspacecreate
#endif
PETSC_EXTERN void matnullspacecreate_(MPI_Fint *a, PetscBool *b, PetscInt *c, const Vec d[], MatNullSpace *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(e);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatNullSpaceCreate(MPI_Comm_f2c(*(a)), *b ? PETSC_TRUE : PETSC_FALSE, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspacedestroy_ MATNULLSPACEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspacedestroy_ matnullspacedestroy
#endif
PETSC_EXTERN void matnullspacedestroy_(MatNullSpace *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatNullSpaceDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspaceremove_ MATNULLSPACEREMOVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspaceremove_ matnullspaceremove
#endif
PETSC_EXTERN void matnullspaceremove_(MatNullSpace *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatNullSpaceRemove(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnullspacetest_ MATNULLSPACETEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnullspacetest_ matnullspacetest
#endif
PETSC_EXTERN void matnullspacetest_(MatNullSpace *a, Mat *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatNullSpaceTest(*a, *b, c);
  if (*ierr) return;
}
