#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlrcgetmats_ MATLRCGETMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlrcgetmats_ matlrcgetmats
#endif
PETSC_EXTERN void matlrcgetmats_(Mat *a, Mat *b, Mat *c, Vec *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatLRCGetMats(*a, b, c, d, e);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlrcsetmats_ MATLRCSETMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlrcsetmats_ matlrcsetmats
#endif
PETSC_EXTERN void matlrcsetmats_(Mat *a, Mat *b, Mat *c, Vec *d, Mat *e, PetscErrorCode *ierr)
{
  *ierr = MatLRCSetMats(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelrc_ MATCREATELRC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelrc_ matcreatelrc
#endif
PETSC_EXTERN void matcreatelrc_(Mat *a, Mat *b, Vec *c, Mat *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateLRC(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
