#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqaijperm_ MATCREATESEQAIJPERM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqaijperm_ matcreateseqaijperm
#endif
PETSC_EXTERN void matcreateseqaijperm_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateSeqAIJPERM(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
