#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninggettype_ MATPARTITIONINGGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninggettype_ matpartitioninggettype
#endif
PETSC_EXTERN void matpartitioninggettype_(MatPartitioning *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatPartitioningGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetnparts_ MATPARTITIONINGSETNPARTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetnparts_ matpartitioningsetnparts
#endif
PETSC_EXTERN void matpartitioningsetnparts_(MatPartitioning *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningSetNParts(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningapplynd_ MATPARTITIONINGAPPLYND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningapplynd_ matpartitioningapplynd
#endif
PETSC_EXTERN void matpartitioningapplynd_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningApplyND(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningapply_ MATPARTITIONINGAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningapply_ matpartitioningapply
#endif
PETSC_EXTERN void matpartitioningapply_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningApply(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningimprove_ MATPARTITIONINGIMPROVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningimprove_ matpartitioningimprove
#endif
PETSC_EXTERN void matpartitioningimprove_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningImprove(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningviewimbalance_ MATPARTITIONINGVIEWIMBALANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningviewimbalance_ matpartitioningviewimbalance
#endif
PETSC_EXTERN void matpartitioningviewimbalance_(MatPartitioning *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningViewImbalance(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetadjacency_ MATPARTITIONINGSETADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetadjacency_ matpartitioningsetadjacency
#endif
PETSC_EXTERN void matpartitioningsetadjacency_(MatPartitioning *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningSetAdjacency(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningdestroy_ MATPARTITIONINGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningdestroy_ matpartitioningdestroy
#endif
PETSC_EXTERN void matpartitioningdestroy_(MatPartitioning *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatPartitioningDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetvertexweights_ MATPARTITIONINGSETVERTEXWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetvertexweights_ matpartitioningsetvertexweights
#endif
PETSC_EXTERN void matpartitioningsetvertexweights_(MatPartitioning *a, const PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatPartitioningSetVertexWeights(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetpartitionweights_ MATPARTITIONINGSETPARTITIONWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetpartitionweights_ matpartitioningsetpartitionweights
#endif
PETSC_EXTERN void matpartitioningsetpartitionweights_(MatPartitioning *a, const PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatPartitioningSetPartitionWeights(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetuseedgeweights_ MATPARTITIONINGSETUSEEDGEWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetuseedgeweights_ matpartitioningsetuseedgeweights
#endif
PETSC_EXTERN void matpartitioningsetuseedgeweights_(MatPartitioning *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningSetUseEdgeWeights(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioninggetuseedgeweights_ MATPARTITIONINGGETUSEEDGEWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioninggetuseedgeweights_ matpartitioninggetuseedgeweights
#endif
PETSC_EXTERN void matpartitioninggetuseedgeweights_(MatPartitioning *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatPartitioningGetUseEdgeWeights(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningcreate_ MATPARTITIONINGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningcreate_ matpartitioningcreate
#endif
PETSC_EXTERN void matpartitioningcreate_(MPI_Fint *a, MatPartitioning *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatPartitioningCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningviewfromoptions_ MATPARTITIONINGVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningviewfromoptions_ matpartitioningviewfromoptions
#endif
PETSC_EXTERN void matpartitioningviewfromoptions_(MatPartitioning *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = MatPartitioningViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningview_ MATPARTITIONINGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningview_ matpartitioningview
#endif
PETSC_EXTERN void matpartitioningview_(MatPartitioning *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatPartitioningView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsettype_ MATPARTITIONINGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsettype_ matpartitioningsettype
#endif
PETSC_EXTERN void matpartitioningsettype_(MatPartitioning *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatPartitioningSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetfromoptions_ MATPARTITIONINGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetfromoptions_ matpartitioningsetfromoptions
#endif
PETSC_EXTERN void matpartitioningsetfromoptions_(MatPartitioning *a, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpartitioningsetnumbervertexweights_ MATPARTITIONINGSETNUMBERVERTEXWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpartitioningsetnumbervertexweights_ matpartitioningsetnumbervertexweights
#endif
PETSC_EXTERN void matpartitioningsetnumbervertexweights_(MatPartitioning *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatPartitioningSetNumberVertexWeights(*a, *b);
  if (*ierr) return;
}
