#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsengettype_ MATCOARSENGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsengettype_ matcoarsengettype
#endif
PETSC_EXTERN void matcoarsengettype_(MatCoarsen *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatCoarsenGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsenapply_ MATCOARSENAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsenapply_ matcoarsenapply
#endif
PETSC_EXTERN void matcoarsenapply_(MatCoarsen *a, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenApply(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetadjacency_ MATCOARSENSETADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetadjacency_ matcoarsensetadjacency
#endif
PETSC_EXTERN void matcoarsensetadjacency_(MatCoarsen *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetAdjacency(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetstrictaggs_ MATCOARSENSETSTRICTAGGS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetstrictaggs_ matcoarsensetstrictaggs
#endif
PETSC_EXTERN void matcoarsensetstrictaggs_(MatCoarsen *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetStrictAggs(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsendestroy_ MATCOARSENDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsendestroy_ matcoarsendestroy
#endif
PETSC_EXTERN void matcoarsendestroy_(MatCoarsen *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = MatCoarsenDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsenviewfromoptions_ MATCOARSENVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsenviewfromoptions_ matcoarsenviewfromoptions
#endif
PETSC_EXTERN void matcoarsenviewfromoptions_(MatCoarsen *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = MatCoarsenViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsenview_ MATCOARSENVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsenview_ matcoarsenview
#endif
PETSC_EXTERN void matcoarsenview_(MatCoarsen *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = MatCoarsenView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensettype_ MATCOARSENSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensettype_ matcoarsensettype
#endif
PETSC_EXTERN void matcoarsensettype_(MatCoarsen *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatCoarsenSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetgreedyordering_ MATCOARSENSETGREEDYORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetgreedyordering_ matcoarsensetgreedyordering
#endif
PETSC_EXTERN void matcoarsensetgreedyordering_(MatCoarsen *a, const IS *b, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetGreedyOrdering(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetfromoptions_ MATCOARSENSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetfromoptions_ matcoarsensetfromoptions
#endif
PETSC_EXTERN void matcoarsensetfromoptions_(MatCoarsen *a, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetmaximumiterations_ MATCOARSENSETMAXIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetmaximumiterations_ matcoarsensetmaximumiterations
#endif
PETSC_EXTERN void matcoarsensetmaximumiterations_(MatCoarsen *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetMaximumIterations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetstrengthindex_ MATCOARSENSETSTRENGTHINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetstrengthindex_ matcoarsensetstrengthindex
#endif
PETSC_EXTERN void matcoarsensetstrengthindex_(MatCoarsen *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatCoarsenSetStrengthIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsensetthreshold_ MATCOARSENSETTHRESHOLD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsensetthreshold_ matcoarsensetthreshold
#endif
PETSC_EXTERN void matcoarsensetthreshold_(MatCoarsen *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatCoarsenSetThreshold(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmatcoarsen.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcoarsencreate_ MATCOARSENCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcoarsencreate_ matcoarsencreate
#endif
PETSC_EXTERN void matcoarsencreate_(MPI_Fint *a, MatCoarsen *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatCoarsenCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
