#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmupdate_ MATLMVMUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmupdate_ matlmvmupdate
#endif
PETSC_EXTERN void matlmvmupdate_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatLMVMUpdate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmclearj0_ MATLMVMCLEARJ0
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmclearj0_ matlmvmclearj0
#endif
PETSC_EXTERN void matlmvmclearj0_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatLMVMClearJ0(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetj0scale_ MATLMVMSETJ0SCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetj0scale_ matlmvmsetj0scale
#endif
PETSC_EXTERN void matlmvmsetj0scale_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetJ0Scale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetj0diag_ MATLMVMSETJ0DIAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetj0diag_ matlmvmsetj0diag
#endif
PETSC_EXTERN void matlmvmsetj0diag_(Mat *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetJ0Diag(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetj0_ MATLMVMSETJ0
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetj0_ matlmvmsetj0
#endif
PETSC_EXTERN void matlmvmsetj0_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetJ0(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetj0pc_ MATLMVMSETJ0PC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetj0pc_ matlmvmsetj0pc
#endif
PETSC_EXTERN void matlmvmsetj0pc_(Mat *a, PC *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetJ0PC(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsetj0ksp_ MATLMVMSETJ0KSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsetj0ksp_ matlmvmsetj0ksp
#endif
PETSC_EXTERN void matlmvmsetj0ksp_(Mat *a, KSP *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetJ0KSP(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetj0_ MATLMVMGETJ0
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetj0_ matlmvmgetj0
#endif
PETSC_EXTERN void matlmvmgetj0_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatLMVMGetJ0(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetj0pc_ MATLMVMGETJ0PC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetj0pc_ matlmvmgetj0pc
#endif
PETSC_EXTERN void matlmvmgetj0pc_(Mat *a, PC *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatLMVMGetJ0PC(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetj0ksp_ MATLMVMGETJ0KSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetj0ksp_ matlmvmgetj0ksp
#endif
PETSC_EXTERN void matlmvmgetj0ksp_(Mat *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatLMVMGetJ0KSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmapplyj0fwd_ MATLMVMAPPLYJ0FWD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmapplyj0fwd_ matlmvmapplyj0fwd
#endif
PETSC_EXTERN void matlmvmapplyj0fwd_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatLMVMApplyJ0Fwd(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmapplyj0inv_ MATLMVMAPPLYJ0INV
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmapplyj0inv_ matlmvmapplyj0inv
#endif
PETSC_EXTERN void matlmvmapplyj0inv_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatLMVMApplyJ0Inv(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmisallocated_ MATLMVMISALLOCATED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmisallocated_ matlmvmisallocated
#endif
PETSC_EXTERN void matlmvmisallocated_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatLMVMIsAllocated(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmallocate_ MATLMVMALLOCATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmallocate_ matlmvmallocate
#endif
PETSC_EXTERN void matlmvmallocate_(Mat *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = MatLMVMAllocate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmresetshift_ MATLMVMRESETSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmresetshift_ matlmvmresetshift
#endif
PETSC_EXTERN void matlmvmresetshift_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatLMVMResetShift(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmreset_ MATLMVMRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmreset_ matlmvmreset
#endif
PETSC_EXTERN void matlmvmreset_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMReset(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmsethistorysize_ MATLMVMSETHISTORYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmsethistorysize_ matlmvmsethistorysize
#endif
PETSC_EXTERN void matlmvmsethistorysize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMSetHistorySize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgethistorysize_ MATLMVMGETHISTORYSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgethistorysize_ matlmvmgethistorysize
#endif
PETSC_EXTERN void matlmvmgethistorysize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatLMVMGetHistorySize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetupdatecount_ MATLMVMGETUPDATECOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetupdatecount_ matlmvmgetupdatecount
#endif
PETSC_EXTERN void matlmvmgetupdatecount_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatLMVMGetUpdateCount(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmgetrejectcount_ MATLMVMGETREJECTCOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmgetrejectcount_ matlmvmgetrejectcount
#endif
PETSC_EXTERN void matlmvmgetrejectcount_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatLMVMGetRejectCount(*a, b);
  if (*ierr) return;
}
