#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionershellsetpartition_ PETSCPARTITIONERSHELLSETPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionershellsetpartition_ petscpartitionershellsetpartition
#endif
PETSC_EXTERN void petscpartitionershellsetpartition_(PetscPartitioner *a, PetscInt *b, const PetscInt c[], const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscPartitionerShellSetPartition(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionershellsetrandom_ PETSCPARTITIONERSHELLSETRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionershellsetrandom_ petscpartitionershellsetrandom
#endif
PETSC_EXTERN void petscpartitionershellsetrandom_(PetscPartitioner *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscPartitionerShellSetRandom(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscpartitioner.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionershellgetrandom_ PETSCPARTITIONERSHELLGETRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionershellgetrandom_ petscpartitionershellgetrandom
#endif
PETSC_EXTERN void petscpartitionershellgetrandom_(PetscPartitioner *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscPartitionerShellGetRandom(*a, b);
  if (*ierr) return;
}
