#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmstag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmstagcreate2d_ DMSTAGCREATE2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmstagcreate2d_ dmstagcreate2d
#endif
PETSC_EXTERN void dmstagcreate2d_(MPI_Fint *a, DMBoundaryType *b, DMBoundaryType *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscInt *j, DMStagStencilType *k, PetscInt *l, const PetscInt m[], const PetscInt n[], DM *o, PetscErrorCode *ierr)
{
  PetscBool null_o = !*(void**) o ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(m);
  CHKFORTRANNULLINTEGER(n);
  CHKFORTRANNULLOBJECT(o);
  *ierr = DMStagCreate2d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, m, n, o);
  if (*ierr) return;
  if (! null_o && !*(void**) o) *(void **) o = (void *)-2;
}
