#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetscale_ DMPLEXGETSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetscale_ dmplexgetscale
#endif
PETSC_EXTERN void dmplexgetscale_(DM *a, PetscUnit *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexGetScale(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetscale_ DMPLEXSETSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetscale_ dmplexsetscale
#endif
PETSC_EXTERN void dmplexsetscale_(DM *a, PetscUnit *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetScale(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetusematclosurepermutation_ DMPLEXGETUSEMATCLOSUREPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetusematclosurepermutation_ dmplexgetusematclosurepermutation
#endif
PETSC_EXTERN void dmplexgetusematclosurepermutation_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetUseMatClosurePermutation(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetusematclosurepermutation_ DMPLEXSETUSEMATCLOSUREPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetusematclosurepermutation_ dmplexsetusematclosurepermutation
#endif
PETSC_EXTERN void dmplexsetusematclosurepermutation_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetUseMatClosurePermutation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreaterigidbody_ DMPLEXCREATERIGIDBODY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreaterigidbody_ dmplexcreaterigidbody
#endif
PETSC_EXTERN void dmplexcreaterigidbody_(DM *a, PetscInt *b, MatNullSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateRigidBody(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreaterigidbodies_ DMPLEXCREATERIGIDBODIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreaterigidbodies_ dmplexcreaterigidbodies
#endif
PETSC_EXTERN void dmplexcreaterigidbodies_(DM *a, PetscInt *b, DMLabel *c, const PetscInt d[], const PetscInt e[], MatNullSpace *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPlexCreateRigidBodies(*a, *b, *c, d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetmaxprojectionheight_ DMPLEXSETMAXPROJECTIONHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetmaxprojectionheight_ dmplexsetmaxprojectionheight
#endif
PETSC_EXTERN void dmplexsetmaxprojectionheight_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetMaxProjectionHeight(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetmaxprojectionheight_ DMPLEXGETMAXPROJECTIONHEIGHT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetmaxprojectionheight_ dmplexgetmaxprojectionheight
#endif
PETSC_EXTERN void dmplexgetmaxprojectionheight_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexGetMaxProjectionHeight(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexglobaltolocalbasis_ DMPLEXGLOBALTOLOCALBASIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexglobaltolocalbasis_ dmplexglobaltolocalbasis
#endif
PETSC_EXTERN void dmplexglobaltolocalbasis_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexGlobalToLocalBasis(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlocaltoglobalbasis_ DMPLEXLOCALTOGLOBALBASIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlocaltoglobalbasis_ dmplexlocaltoglobalbasis
#endif
PETSC_EXTERN void dmplexlocaltoglobalbasis_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLocalToGlobalBasis(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatebasisrotation_ DMPLEXCREATEBASISROTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatebasisrotation_ dmplexcreatebasisrotation
#endif
PETSC_EXTERN void dmplexcreatebasisrotation_(DM *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexCreateBasisRotation(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertboundaryvalues_ DMPLEXINSERTBOUNDARYVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertboundaryvalues_ dmplexinsertboundaryvalues
#endif
PETSC_EXTERN void dmplexinsertboundaryvalues_(DM *a, PetscBool *b, Vec *c, PetscReal *d, Vec *e, Vec *f, Vec *g, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertBoundaryValues(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinserttimederivativeboundaryvalues_ DMPLEXINSERTTIMEDERIVATIVEBOUNDARYVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinserttimederivativeboundaryvalues_ dmplexinserttimederivativeboundaryvalues
#endif
PETSC_EXTERN void dmplexinserttimederivativeboundaryvalues_(DM *a, PetscBool *b, Vec *c, PetscReal *d, Vec *e, Vec *f, Vec *g, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertTimeDerivativeBoundaryValues(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertbounds_ DMPLEXINSERTBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertbounds_ dmplexinsertbounds
#endif
PETSC_EXTERN void dmplexinsertbounds_(DM *a, PetscBool *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexInsertBounds(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinsertboundaryvaluesfvm_ DMPLEXINSERTBOUNDARYVALUESFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinsertboundaryvaluesfvm_ dmplexinsertboundaryvaluesfvm
#endif
PETSC_EXTERN void dmplexinsertboundaryvaluesfvm_(DM *a, PetscFV *b, Vec *c, PetscReal *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexInsertBoundaryValuesFVM(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputel2fluxdiffveclocal_ DMPLEXCOMPUTEL2FLUXDIFFVECLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputel2fluxdiffveclocal_ dmplexcomputel2fluxdiffveclocal
#endif
PETSC_EXTERN void dmplexcomputel2fluxdiffveclocal_(Vec *a, PetscInt *b, Vec *c, PetscInt *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeL2FluxDiffVecLocal(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputel2fluxdiffvec_ DMPLEXCOMPUTEL2FLUXDIFFVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputel2fluxdiffvec_ dmplexcomputel2fluxdiffvec
#endif
PETSC_EXTERN void dmplexcomputel2fluxdiffvec_(Vec *a, PetscInt *b, Vec *c, PetscInt *d, Vec *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeL2FluxDiffVec(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeclementinterpolant_ DMPLEXCOMPUTECLEMENTINTERPOLANT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeclementinterpolant_ dmplexcomputeclementinterpolant
#endif
PETSC_EXTERN void dmplexcomputeclementinterpolant_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeClementInterpolant(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputegradientclementinterpolant_ DMPLEXCOMPUTEGRADIENTCLEMENTINTERPOLANT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputegradientclementinterpolant_ dmplexcomputegradientclementinterpolant
#endif
PETSC_EXTERN void dmplexcomputegradientclementinterpolant_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeGradientClementInterpolant(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeintegralfem_ DMPLEXCOMPUTEINTEGRALFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeintegralfem_ dmplexcomputeintegralfem
#endif
PETSC_EXTERN void dmplexcomputeintegralfem_(DM *a, Vec *b, PetscScalar *c, void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexComputeIntegralFEM(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputecellwiseintegralfem_ DMPLEXCOMPUTECELLWISEINTEGRALFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputecellwiseintegralfem_ dmplexcomputecellwiseintegralfem
#endif
PETSC_EXTERN void dmplexcomputecellwiseintegralfem_(DM *a, Vec *b, Vec *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeCellwiseIntegralFEM(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeinterpolatornested_ DMPLEXCOMPUTEINTERPOLATORNESTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeinterpolatornested_ dmplexcomputeinterpolatornested
#endif
PETSC_EXTERN void dmplexcomputeinterpolatornested_(DM *a, DM *b, PetscBool *c, Mat *d, void *e, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeInterpolatorNested(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputemassmatrixnested_ DMPLEXCOMPUTEMASSMATRIXNESTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputemassmatrixnested_ dmplexcomputemassmatrixnested
#endif
PETSC_EXTERN void dmplexcomputemassmatrixnested_(DM *a, DM *b, Mat *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeMassMatrixNested(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeinterpolatorgeneral_ DMPLEXCOMPUTEINTERPOLATORGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeinterpolatorgeneral_ dmplexcomputeinterpolatorgeneral
#endif
PETSC_EXTERN void dmplexcomputeinterpolatorgeneral_(DM *a, DM *b, Mat *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeInterpolatorGeneral(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputemassmatrixgeneral_ DMPLEXCOMPUTEMASSMATRIXGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputemassmatrixgeneral_ dmplexcomputemassmatrixgeneral
#endif
PETSC_EXTERN void dmplexcomputemassmatrixgeneral_(DM *a, DM *b, Mat *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeMassMatrixGeneral(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeinjectorfem_ DMPLEXCOMPUTEINJECTORFEM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeinjectorfem_ dmplexcomputeinjectorfem
#endif
PETSC_EXTERN void dmplexcomputeinjectorfem_(DM *a, DM *b, VecScatter *c, void *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeInjectorFEM(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetgeometryfvm_ DMPLEXGETGEOMETRYFVM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetgeometryfvm_ dmplexgetgeometryfvm
#endif
PETSC_EXTERN void dmplexgetgeometryfvm_(DM *a, Vec *b, Vec *c, PetscReal *d, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLREAL(d);
  *ierr = DMPlexGetGeometryFVM(*a, b, c, d);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetgradientdm_ DMPLEXGETGRADIENTDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetgradientdm_ dmplexgetgradientdm
#endif
PETSC_EXTERN void dmplexgetgradientdm_(DM *a, PetscFV *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexGetGradientDM(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputebdresidualsinglebykey_ DMPLEXCOMPUTEBDRESIDUALSINGLEBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputebdresidualsinglebykey_ dmplexcomputebdresidualsinglebykey
#endif
PETSC_EXTERN void dmplexcomputebdresidualsinglebykey_(DM *a, PetscWeakForm *b, PetscFormKey *c, IS *d, Vec *e, Vec *f, PetscReal *g, DMField *h, Vec *i, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeBdResidualSingleByKey(*a, *b, *c, *d, *e, *f, *g, *h, *i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputebdresidualsingle_ DMPLEXCOMPUTEBDRESIDUALSINGLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputebdresidualsingle_ dmplexcomputebdresidualsingle
#endif
PETSC_EXTERN void dmplexcomputebdresidualsingle_(DM *a, PetscWeakForm *b, PetscFormKey *c, Vec *d, Vec *e, PetscReal *f, Vec *g, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeBdResidualSingle(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeresidualbykey_ DMPLEXCOMPUTERESIDUALBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeresidualbykey_ dmplexcomputeresidualbykey
#endif
PETSC_EXTERN void dmplexcomputeresidualbykey_(DM *a, PetscFormKey *b, IS *c, PetscReal *d, Vec *e, Vec *f, PetscReal *g, Vec *h, void *i, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeResidualByKey(*a, *b, *c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputeresidualhybridbykey_ DMPLEXCOMPUTERESIDUALHYBRIDBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputeresidualhybridbykey_ dmplexcomputeresidualhybridbykey
#endif
PETSC_EXTERN void dmplexcomputeresidualhybridbykey_(DM *a, PetscFormKey b[], IS *c, PetscReal *d, Vec *e, Vec *f, PetscReal *g, Vec *h, void *i, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeResidualHybridByKey(*a, b, *c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputebdjacobiansinglebylabel_ DMPLEXCOMPUTEBDJACOBIANSINGLEBYLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputebdjacobiansinglebylabel_ dmplexcomputebdjacobiansinglebylabel
#endif
PETSC_EXTERN void dmplexcomputebdjacobiansinglebylabel_(DM *a, PetscWeakForm *b, DMLabel *c, PetscInt *d, const PetscInt e[], PetscInt *f, IS *g, Vec *h, Vec *i, PetscReal *j, DMField *k, PetscReal *l, Mat *m, Mat *n, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMPlexComputeBdJacobianSingleByLabel(*a, *b, *c, *d, e, *f, *g, *h, *i, *j, *k, *l, *m, *n);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputebdjacobiansingle_ DMPLEXCOMPUTEBDJACOBIANSINGLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputebdjacobiansingle_ dmplexcomputebdjacobiansingle
#endif
PETSC_EXTERN void dmplexcomputebdjacobiansingle_(DM *a, PetscWeakForm *b, DMLabel *c, PetscInt *d, const PetscInt e[], PetscInt *f, Vec *g, Vec *h, PetscReal *i, PetscReal *j, Mat *k, Mat *l, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMPlexComputeBdJacobianSingle(*a, *b, *c, *d, e, *f, *g, *h, *i, *j, *k, *l);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputejacobianbykey_ DMPLEXCOMPUTEJACOBIANBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputejacobianbykey_ dmplexcomputejacobianbykey
#endif
PETSC_EXTERN void dmplexcomputejacobianbykey_(DM *a, PetscFormKey *b, IS *c, PetscReal *d, PetscReal *e, Vec *f, Vec *g, Mat *h, Mat *i, void *j, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeJacobianByKey(*a, *b, *c, *d, *e, *f, *g, *h, *i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputejacobianbykeygeneral_ DMPLEXCOMPUTEJACOBIANBYKEYGENERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputejacobianbykeygeneral_ dmplexcomputejacobianbykeygeneral
#endif
PETSC_EXTERN void dmplexcomputejacobianbykeygeneral_(DM *a, DM *b, PetscFormKey *c, IS *d, PetscReal *e, PetscReal *f, Vec *g, Vec *h, Mat *i, Mat *j, void *k, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeJacobianByKeyGeneral(*a, *b, *c, *d, *e, *f, *g, *h, *i, *j, k);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputejacobianhybridbykey_ DMPLEXCOMPUTEJACOBIANHYBRIDBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputejacobianhybridbykey_ dmplexcomputejacobianhybridbykey
#endif
PETSC_EXTERN void dmplexcomputejacobianhybridbykey_(DM *a, PetscFormKey b[], IS *c, PetscReal *d, PetscReal *e, Vec *f, Vec *g, Mat *h, Mat *i, void *j, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeJacobianHybridByKey(*a, b, *c, *d, *e, *f, *g, *h, *i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputejacobianactionbykey_ DMPLEXCOMPUTEJACOBIANACTIONBYKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputejacobianactionbykey_ dmplexcomputejacobianactionbykey
#endif
PETSC_EXTERN void dmplexcomputejacobianactionbykey_(DM *a, PetscFormKey *b, IS *c, PetscReal *d, PetscReal *e, Vec *f, Vec *g, Vec *h, Vec *i, void *j, PetscErrorCode *ierr)
{
  *ierr = DMPlexComputeJacobianActionByKey(*a, *b, *c, *d, *e, *f, *g, *h, *i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcomputemoments_ DMPLEXCOMPUTEMOMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcomputemoments_ dmplexcomputemoments
#endif
PETSC_EXTERN void dmplexcomputemoments_(DM *a, Vec *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexComputeMoments(*a, *b, c);
  if (*ierr) return;
}
