#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecoordinatespace_ DMPLEXCREATECOORDINATESPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecoordinatespace_ dmplexcreatecoordinatespace
#endif
PETSC_EXTERN void dmplexcreatecoordinatespace_(DM *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexCreateCoordinateSpace(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatedoublet_ DMPLEXCREATEDOUBLET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatedoublet_ dmplexcreatedoublet
#endif
PETSC_EXTERN void dmplexcreatedoublet_(MPI_Fint *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscReal *e, DM *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPlexCreateDoublet(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateboxsurfacemesh_ DMPLEXCREATEBOXSURFACEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateboxsurfacemesh_ dmplexcreateboxsurfacemesh
#endif
PETSC_EXTERN void dmplexcreateboxsurfacemesh_(MPI_Fint *a, PetscInt *b, const PetscInt c[], const PetscReal d[], const PetscReal e[], PetscBool *f, DM *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMPlexCreateBoxSurfaceMesh(MPI_Comm_f2c(*(a)), *b, c, d, e, *f ? PETSC_TRUE : PETSC_FALSE, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateboxmesh_ DMPLEXCREATEBOXMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateboxmesh_ dmplexcreateboxmesh
#endif
PETSC_EXTERN void dmplexcreateboxmesh_(MPI_Fint *a, PetscInt *b, PetscBool *c, const PetscInt d[], const PetscReal e[], const PetscReal f[], const DMBoundaryType g[], PetscBool *h, PetscInt *i, PetscBool *j, DM *k, PetscErrorCode *ierr)
{
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLOBJECT(k);
  *ierr = DMPlexCreateBoxMesh(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d, e, f, g, *h ? PETSC_TRUE : PETSC_FALSE, *i, *j ? PETSC_TRUE : PETSC_FALSE, k);
  if (*ierr) return;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatewedgeboxmesh_ DMPLEXCREATEWEDGEBOXMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatewedgeboxmesh_ dmplexcreatewedgeboxmesh
#endif
PETSC_EXTERN void dmplexcreatewedgeboxmesh_(MPI_Fint *a, const PetscInt b[], const PetscReal c[], const PetscReal d[], const DMBoundaryType e[], PetscBool *f, PetscBool *g, DM *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(h);
  *ierr = DMPlexCreateWedgeBoxMesh(MPI_Comm_f2c(*(a)), b, c, d, e, *f ? PETSC_TRUE : PETSC_FALSE, *g ? PETSC_TRUE : PETSC_FALSE, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatehypercubicmesh_ DMPLEXCREATEHYPERCUBICMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatehypercubicmesh_ dmplexcreatehypercubicmesh
#endif
PETSC_EXTERN void dmplexcreatehypercubicmesh_(MPI_Fint *a, PetscInt *b, const PetscInt c[], const PetscReal d[], const PetscReal e[], PetscInt *f, DM *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMPlexCreateHypercubicMesh(MPI_Comm_f2c(*(a)), *b, c, d, e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetoptionsprefix_ DMPLEXSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetoptionsprefix_ dmplexsetoptionsprefix
#endif
PETSC_EXTERN void dmplexsetoptionsprefix_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatehexcylindermesh_ DMPLEXCREATEHEXCYLINDERMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatehexcylindermesh_ dmplexcreatehexcylindermesh
#endif
PETSC_EXTERN void dmplexcreatehexcylindermesh_(MPI_Fint *a, DMBoundaryType *b, PetscInt *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateHexCylinderMesh(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatewedgecylindermesh_ DMPLEXCREATEWEDGECYLINDERMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatewedgecylindermesh_ dmplexcreatewedgecylindermesh
#endif
PETSC_EXTERN void dmplexcreatewedgecylindermesh_(MPI_Fint *a, PetscInt *b, PetscBool *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateWedgeCylinderMesh(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatetpsmesh_ DMPLEXCREATETPSMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatetpsmesh_ dmplexcreatetpsmesh
#endif
PETSC_EXTERN void dmplexcreatetpsmesh_(MPI_Fint *a, DMPlexTPSType *b, const PetscInt c[], const DMBoundaryType d[], PetscBool *e, PetscInt *f, PetscInt *g, PetscReal *h, DM *i, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(i);
  *ierr = DMPlexCreateTPSMesh(MPI_Comm_f2c(*(a)), *b, c, d, *e ? PETSC_TRUE : PETSC_FALSE, *f, *g, *h, i);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatespheremesh_ DMPLEXCREATESPHEREMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatespheremesh_ dmplexcreatespheremesh
#endif
PETSC_EXTERN void dmplexcreatespheremesh_(MPI_Fint *a, PetscInt *b, PetscBool *c, PetscReal *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexCreateSphereMesh(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateballmesh_ DMPLEXCREATEBALLMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateballmesh_ dmplexcreateballmesh
#endif
PETSC_EXTERN void dmplexcreateballmesh_(MPI_Fint *a, PetscInt *b, PetscReal *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateBallMesh(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatereferencecell_ DMPLEXCREATEREFERENCECELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatereferencecell_ dmplexcreatereferencecell
#endif
PETSC_EXTERN void dmplexcreatereferencecell_(MPI_Fint *a, DMPolytopeType *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateReferenceCell(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreate_ DMPLEXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreate_ dmplexcreate
#endif
PETSC_EXTERN void dmplexcreate_(MPI_Fint *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexbuildcoordinatesfromcelllistparallel_ DMPLEXBUILDCOORDINATESFROMCELLLISTPARALLEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexbuildcoordinatesfromcelllistparallel_ dmplexbuildcoordinatesfromcelllistparallel
#endif
PETSC_EXTERN void dmplexbuildcoordinatesfromcelllistparallel_(DM *a, PetscInt *b, PetscSF *c, const PetscReal d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = DMPlexBuildCoordinatesFromCellListParallel(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexbuildfromcelllist_ DMPLEXBUILDFROMCELLLIST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexbuildfromcelllist_ dmplexbuildfromcelllist
#endif
PETSC_EXTERN void dmplexbuildfromcelllist_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMPlexBuildFromCellList(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexbuildcoordinatesfromcelllist_ DMPLEXBUILDCOORDINATESFROMCELLLIST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexbuildcoordinatesfromcelllist_ dmplexbuildcoordinatesfromcelllist
#endif
PETSC_EXTERN void dmplexbuildcoordinatesfromcelllist_(DM *a, PetscInt *b, const PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexBuildCoordinatesFromCellList(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatefromcelllistpetsc_ DMPLEXCREATEFROMCELLLISTPETSC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatefromcelllistpetsc_ dmplexcreatefromcelllistpetsc
#endif
PETSC_EXTERN void dmplexcreatefromcelllistpetsc_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscBool *f, const PetscInt g[], PetscInt *h, const PetscReal i[], DM *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLREAL(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = DMPlexCreateFromCellListPetsc(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f ? PETSC_TRUE : PETSC_FALSE, g, *h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatefromdag_ DMPLEXCREATEFROMDAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatefromdag_ dmplexcreatefromdag
#endif
PETSC_EXTERN void dmplexcreatefromdag_(DM *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscInt e[], const PetscInt f[], const PetscScalar g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLSCALAR(g);
  *ierr = DMPlexCreateFromDAG(*a, *b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatefromfile_ DMPLEXCREATEFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatefromfile_ dmplexcreatefromfile
#endif
PETSC_EXTERN void dmplexcreatefromfile_(MPI_Fint *a, char b[], char c[], PetscBool *d, DM *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexCreateFromFile(MPI_Comm_f2c(*(a)), c_b, c_c, *d ? PETSC_TRUE : PETSC_FALSE, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateephemeral_ DMPLEXCREATEEPHEMERAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateephemeral_ dmplexcreateephemeral
#endif
PETSC_EXTERN void dmplexcreateephemeral_(DMPlexTransform *a, char b[], DM *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateEphemeral(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
