#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchzoom_ DMPATCHZOOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchzoom_ dmpatchzoom
#endif
PETSC_EXTERN void dmpatchzoom_(DM *a, MatStencil *b, MatStencil *c, MPI_Fint *d, DM *e, PetscSF *f, PetscSF *g, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMPatchZoom(*a, *b, *c, MPI_Comm_f2c(*(d)), e, f, g);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchsolve_ DMPATCHSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchsolve_ dmpatchsolve
#endif
PETSC_EXTERN void dmpatchsolve_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPatchSolve(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchgetcoarse_ DMPATCHGETCOARSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchgetcoarse_ dmpatchgetcoarse
#endif
PETSC_EXTERN void dmpatchgetcoarse_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPatchGetCoarse(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchgetpatchsize_ DMPATCHGETPATCHSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchgetpatchsize_ dmpatchgetpatchsize
#endif
PETSC_EXTERN void dmpatchgetpatchsize_(DM *a, MatStencil *b, PetscErrorCode *ierr)
{
  *ierr = DMPatchGetPatchSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchsetpatchsize_ DMPATCHSETPATCHSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchsetpatchsize_ dmpatchsetpatchsize
#endif
PETSC_EXTERN void dmpatchsetpatchsize_(DM *a, MatStencil *b, PetscErrorCode *ierr)
{
  *ierr = DMPatchSetPatchSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchgetcommsize_ DMPATCHGETCOMMSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchgetcommsize_ dmpatchgetcommsize
#endif
PETSC_EXTERN void dmpatchgetcommsize_(DM *a, MatStencil *b, PetscErrorCode *ierr)
{
  *ierr = DMPatchGetCommSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmpatch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmpatchsetcommsize_ DMPATCHSETCOMMSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmpatchsetcommsize_ dmpatchsetcommsize
#endif
PETSC_EXTERN void dmpatchsetcommsize_(DM *a, MatStencil *b, PetscErrorCode *ierr)
{
  *ierr = DMPatchSetCommSize(*a, *b);
  if (*ierr) return;
}
