#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssettype_ PETSCDSSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssettype_ petscdssettype
#endif
PETSC_EXTERN void petscdssettype_(PetscDS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDSSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgettype_ PETSCDSGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgettype_ petscdsgettype
#endif
PETSC_EXTERN void petscdsgettype_(PetscDS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscDSGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsviewfromoptions_ PETSCDSVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsviewfromoptions_ petscdsviewfromoptions
#endif
PETSC_EXTERN void petscdsviewfromoptions_(PetscDS *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscDSViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsview_ PETSCDSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsview_ petscdsview
#endif
PETSC_EXTERN void petscdsview_(PetscDS *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDSView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetfromoptions_ PETSCDSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetfromoptions_ petscdssetfromoptions
#endif
PETSC_EXTERN void petscdssetfromoptions_(PetscDS *a, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetup_ PETSCDSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetup_ petscdssetup
#endif
PETSC_EXTERN void petscdssetup_(PetscDS *a, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsdestroy_ PETSCDSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsdestroy_ petscdsdestroy
#endif
PETSC_EXTERN void petscdsdestroy_(PetscDS *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDSDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscreate_ PETSCDSCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscreate_ petscdscreate
#endif
PETSC_EXTERN void petscdscreate_(MPI_Fint *a, PetscDS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDSCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetnumfields_ PETSCDSGETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetnumfields_ petscdsgetnumfields
#endif
PETSC_EXTERN void petscdsgetnumfields_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetNumFields(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetspatialdimension_ PETSCDSGETSPATIALDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetspatialdimension_ petscdsgetspatialdimension
#endif
PETSC_EXTERN void petscdsgetspatialdimension_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetSpatialDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetcoordinatedimension_ PETSCDSGETCOORDINATEDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetcoordinatedimension_ petscdsgetcoordinatedimension
#endif
PETSC_EXTERN void petscdsgetcoordinatedimension_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetCoordinateDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetcoordinatedimension_ PETSCDSSETCOORDINATEDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetcoordinatedimension_ petscdssetcoordinatedimension
#endif
PETSC_EXTERN void petscdssetcoordinatedimension_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetCoordinateDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetforcequad_ PETSCDSGETFORCEQUAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetforcequad_ petscdsgetforcequad
#endif
PETSC_EXTERN void petscdsgetforcequad_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSGetForceQuad(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetforcequad_ PETSCDSSETFORCEQUAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetforcequad_ petscdssetforcequad
#endif
PETSC_EXTERN void petscdssetforcequad_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetForceQuad(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsiscohesive_ PETSCDSISCOHESIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsiscohesive_ petscdsiscohesive
#endif
PETSC_EXTERN void petscdsiscohesive_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSIsCohesive(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetnumcohesive_ PETSCDSGETNUMCOHESIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetnumcohesive_ petscdsgetnumcohesive
#endif
PETSC_EXTERN void petscdsgetnumcohesive_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetNumCohesive(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetcohesive_ PETSCDSGETCOHESIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetcohesive_ petscdsgetcohesive
#endif
PETSC_EXTERN void petscdsgetcohesive_(PetscDS *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscDSGetCohesive(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetcohesive_ PETSCDSSETCOHESIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetcohesive_ petscdssetcohesive
#endif
PETSC_EXTERN void petscdssetcohesive_(PetscDS *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetCohesive(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgettotaldimension_ PETSCDSGETTOTALDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgettotaldimension_ petscdsgettotaldimension
#endif
PETSC_EXTERN void petscdsgettotaldimension_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetTotalDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgettotalcomponents_ PETSCDSGETTOTALCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgettotalcomponents_ petscdsgettotalcomponents
#endif
PETSC_EXTERN void petscdsgettotalcomponents_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetTotalComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetdiscretization_ PETSCDSGETDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetdiscretization_ petscdsgetdiscretization
#endif
PETSC_EXTERN void petscdsgetdiscretization_(PetscDS *a, PetscInt *b, PetscObject *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDSGetDiscretization(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetdiscretization_ PETSCDSSETDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetdiscretization_ petscdssetdiscretization
#endif
PETSC_EXTERN void petscdssetdiscretization_(PetscDS *a, PetscInt *b, PetscObject *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetDiscretization(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetweakform_ PETSCDSGETWEAKFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetweakform_ petscdsgetweakform
#endif
PETSC_EXTERN void petscdsgetweakform_(PetscDS *a, PetscWeakForm *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDSGetWeakForm(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetweakform_ PETSCDSSETWEAKFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetweakform_ petscdssetweakform
#endif
PETSC_EXTERN void petscdssetweakform_(PetscDS *a, PetscWeakForm *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetWeakForm(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsadddiscretization_ PETSCDSADDDISCRETIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsadddiscretization_ petscdsadddiscretization
#endif
PETSC_EXTERN void petscdsadddiscretization_(PetscDS *a, PetscObject *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSAddDiscretization(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetquadrature_ PETSCDSGETQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetquadrature_ petscdsgetquadrature
#endif
PETSC_EXTERN void petscdsgetquadrature_(PetscDS *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDSGetQuadrature(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetimplicit_ PETSCDSGETIMPLICIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetimplicit_ petscdsgetimplicit
#endif
PETSC_EXTERN void petscdsgetimplicit_(PetscDS *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscDSGetImplicit(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetimplicit_ PETSCDSSETIMPLICIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetimplicit_ petscdssetimplicit
#endif
PETSC_EXTERN void petscdssetimplicit_(PetscDS *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetImplicit(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetjetdegree_ PETSCDSGETJETDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetjetdegree_ petscdsgetjetdegree
#endif
PETSC_EXTERN void petscdsgetjetdegree_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetJetDegree(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetjetdegree_ PETSCDSSETJETDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetjetdegree_ petscdssetjetdegree
#endif
PETSC_EXTERN void petscdssetjetdegree_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetJetDegree(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdshasjacobian_ PETSCDSHASJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdshasjacobian_ petscdshasjacobian
#endif
PETSC_EXTERN void petscdshasjacobian_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSHasJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsusejacobianpreconditioner_ PETSCDSUSEJACOBIANPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsusejacobianpreconditioner_ petscdsusejacobianpreconditioner
#endif
PETSC_EXTERN void petscdsusejacobianpreconditioner_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSUseJacobianPreconditioner(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdshasjacobianpreconditioner_ PETSCDSHASJACOBIANPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdshasjacobianpreconditioner_ petscdshasjacobianpreconditioner
#endif
PETSC_EXTERN void petscdshasjacobianpreconditioner_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSHasJacobianPreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdshasdynamicjacobian_ PETSCDSHASDYNAMICJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdshasdynamicjacobian_ petscdshasdynamicjacobian
#endif
PETSC_EXTERN void petscdshasdynamicjacobian_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSHasDynamicJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetcontext_ PETSCDSGETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetcontext_ petscdsgetcontext
#endif
PETSC_EXTERN void petscdsgetcontext_(PetscDS *a, PetscInt *b, void *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSGetContext(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetcontext_ PETSCDSSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetcontext_ petscdssetcontext
#endif
PETSC_EXTERN void petscdssetcontext_(PetscDS *a, PetscInt *b, void *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetContext(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdshasbdjacobian_ PETSCDSHASBDJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdshasbdjacobian_ petscdshasbdjacobian
#endif
PETSC_EXTERN void petscdshasbdjacobian_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSHasBdJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdshasbdjacobianpreconditioner_ PETSCDSHASBDJACOBIANPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdshasbdjacobianpreconditioner_ petscdshasbdjacobianpreconditioner
#endif
PETSC_EXTERN void petscdshasbdjacobianpreconditioner_(PetscDS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDSHasBdJacobianPreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetconstants_ PETSCDSSETCONSTANTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetconstants_ petscdssetconstants
#endif
PETSC_EXTERN void petscdssetconstants_(PetscDS *a, PetscInt *b, PetscScalar c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscDSSetConstants(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetintegrationparameters_ PETSCDSSETINTEGRATIONPARAMETERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetintegrationparameters_ petscdssetintegrationparameters
#endif
PETSC_EXTERN void petscdssetintegrationparameters_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetIntegrationParameters(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdssetcellparameters_ PETSCDSSETCELLPARAMETERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdssetcellparameters_ petscdssetcellparameters
#endif
PETSC_EXTERN void petscdssetcellparameters_(PetscDS *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSSetCellParameters(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetfieldindex_ PETSCDSGETFIELDINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetfieldindex_ petscdsgetfieldindex
#endif
PETSC_EXTERN void petscdsgetfieldindex_(PetscDS *a, PetscObject *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetFieldIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetfieldsize_ PETSCDSGETFIELDSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetfieldsize_ petscdsgetfieldsize
#endif
PETSC_EXTERN void petscdsgetfieldsize_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetFieldSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetfieldoffset_ PETSCDSGETFIELDOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetfieldoffset_ petscdsgetfieldoffset
#endif
PETSC_EXTERN void petscdsgetfieldoffset_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetFieldOffset(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetfieldoffsetcohesive_ PETSCDSGETFIELDOFFSETCOHESIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetfieldoffsetcohesive_ petscdsgetfieldoffsetcohesive
#endif
PETSC_EXTERN void petscdsgetfieldoffsetcohesive_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetFieldOffsetCohesive(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetcomponentoffset_ PETSCDSGETCOMPONENTOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetcomponentoffset_ petscdsgetcomponentoffset
#endif
PETSC_EXTERN void petscdsgetcomponentoffset_(PetscDS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSGetComponentOffset(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetnumboundary_ PETSCDSGETNUMBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetnumboundary_ petscdsgetnumboundary
#endif
PETSC_EXTERN void petscdsgetnumboundary_(PetscDS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDSGetNumBoundary(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsupdateboundarylabels_ PETSCDSUPDATEBOUNDARYLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsupdateboundarylabels_ petscdsupdateboundarylabels
#endif
PETSC_EXTERN void petscdsupdateboundarylabels_(PetscDS *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSUpdateBoundaryLabels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopyboundary_ PETSCDSCOPYBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopyboundary_ petscdscopyboundary
#endif
PETSC_EXTERN void petscdscopyboundary_(PetscDS *a, PetscInt *b, const PetscInt c[], PetscDS *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSCopyBoundary(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsdestroyboundary_ PETSCDSDESTROYBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsdestroyboundary_ petscdsdestroyboundary
#endif
PETSC_EXTERN void petscdsdestroyboundary_(PetscDS *a, PetscErrorCode *ierr)
{
  *ierr = PetscDSDestroyBoundary(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsselectdiscretizations_ PETSCDSSELECTDISCRETIZATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsselectdiscretizations_ petscdsselectdiscretizations
#endif
PETSC_EXTERN void petscdsselectdiscretizations_(PetscDS *a, PetscInt *b, const PetscInt c[], PetscInt *d, PetscInt *e, PetscDS *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSSelectDiscretizations(*a, *b, c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsselectequations_ PETSCDSSELECTEQUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsselectequations_ petscdsselectequations
#endif
PETSC_EXTERN void petscdsselectequations_(PetscDS *a, PetscInt *b, const PetscInt c[], PetscDS *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscDSSelectEquations(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopyequations_ PETSCDSCOPYEQUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopyequations_ petscdscopyequations
#endif
PETSC_EXTERN void petscdscopyequations_(PetscDS *a, PetscDS *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSCopyEquations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopyconstants_ PETSCDSCOPYCONSTANTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopyconstants_ petscdscopyconstants
#endif
PETSC_EXTERN void petscdscopyconstants_(PetscDS *a, PetscDS *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSCopyConstants(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopyexactsolutions_ PETSCDSCOPYEXACTSOLUTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopyexactsolutions_ petscdscopyexactsolutions
#endif
PETSC_EXTERN void petscdscopyexactsolutions_(PetscDS *a, PetscDS *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSCopyExactSolutions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopybounds_ PETSCDSCOPYBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopybounds_ petscdscopybounds
#endif
PETSC_EXTERN void petscdscopybounds_(PetscDS *a, PetscDS *b, PetscErrorCode *ierr)
{
  *ierr = PetscDSCopyBounds(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdscopy_ PETSCDSCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdscopy_ petscdscopy
#endif
PETSC_EXTERN void petscdscopy_(PetscDS *a, PetscInt *b, PetscInt *c, DM *d, PetscDS *e, PetscErrorCode *ierr)
{
  *ierr = PetscDSCopy(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdsgetheightsubspace_ PETSCDSGETHEIGHTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdsgetheightsubspace_ petscdsgetheightsubspace
#endif
PETSC_EXTERN void petscdsgetheightsubspace_(PetscDS *a, PetscInt *b, PetscDS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDSGetHeightSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdspermutequadpoint_ PETSCDSPERMUTEQUADPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdspermutequadpoint_ petscdspermutequadpoint
#endif
PETSC_EXTERN void petscdspermutequadpoint_(PetscDS *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscDSPermuteQuadPoint(*a, *b, *c, *d, e);
  if (*ierr) return;
}
