#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumgetnumsubspaces_ PETSCDUALSPACESUMGETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumgetnumsubspaces_ petscdualspacesumgetnumsubspaces
#endif
PETSC_EXTERN void petscdualspacesumgetnumsubspaces_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceSumGetNumSubspaces(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumsetnumsubspaces_ PETSCDUALSPACESUMSETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumsetnumsubspaces_ petscdualspacesumsetnumsubspaces
#endif
PETSC_EXTERN void petscdualspacesumsetnumsubspaces_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSumSetNumSubspaces(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumgetconcatenate_ PETSCDUALSPACESUMGETCONCATENATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumgetconcatenate_ petscdualspacesumgetconcatenate
#endif
PETSC_EXTERN void petscdualspacesumgetconcatenate_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceSumGetConcatenate(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumsetconcatenate_ PETSCDUALSPACESUMSETCONCATENATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumsetconcatenate_ petscdualspacesumsetconcatenate
#endif
PETSC_EXTERN void petscdualspacesumsetconcatenate_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSumSetConcatenate(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumgetsubspace_ PETSCDUALSPACESUMGETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumgetsubspace_ petscdualspacesumgetsubspace
#endif
PETSC_EXTERN void petscdualspacesumgetsubspace_(PetscDualSpace *a, PetscInt *b, PetscDualSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceSumGetSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumsetsubspace_ PETSCDUALSPACESUMSETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumsetsubspace_ petscdualspacesumsetsubspace
#endif
PETSC_EXTERN void petscdualspacesumsetsubspace_(PetscDualSpace *a, PetscInt *b, PetscDualSpace *c, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSumSetSubspace(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumsetinterleave_ PETSCDUALSPACESUMSETINTERLEAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumsetinterleave_ petscdualspacesumsetinterleave
#endif
PETSC_EXTERN void petscdualspacesumsetinterleave_(PetscDualSpace *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSumSetInterleave(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesumgetinterleave_ PETSCDUALSPACESUMGETINTERLEAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesumgetinterleave_ petscdualspacesumgetinterleave
#endif
PETSC_EXTERN void petscdualspacesumgetinterleave_(PetscDualSpace *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscDualSpaceSumGetInterleave(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacecreatesum_ PETSCDUALSPACECREATESUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacecreatesum_ petscdualspacecreatesum
#endif
PETSC_EXTERN void petscdualspacecreatesum_(PetscInt *a, const PetscDualSpace b[], PetscBool *c, PetscDualSpace *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscDualSpaceCreateSum(*a, b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
