#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercreate_ VECTAGGERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercreate_ vectaggercreate
#endif
PETSC_EXTERN void vectaggercreate_(MPI_Fint *a, VecTagger *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecTaggerCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggersettype_ VECTAGGERSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggersettype_ vectaggersettype
#endif
PETSC_EXTERN void vectaggersettype_(VecTagger *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = VecTaggerSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggergettype_ VECTAGGERGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggergettype_ vectaggergettype
#endif
PETSC_EXTERN void vectaggergettype_(VecTagger *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = VecTaggerGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggerdestroy_ VECTAGGERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggerdestroy_ vectaggerdestroy
#endif
PETSC_EXTERN void vectaggerdestroy_(VecTagger *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = VecTaggerDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggersetup_ VECTAGGERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggersetup_ vectaggersetup
#endif
PETSC_EXTERN void vectaggersetup_(VecTagger *a, PetscErrorCode *ierr)
{
  *ierr = VecTaggerSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggersetfromoptions_ VECTAGGERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggersetfromoptions_ vectaggersetfromoptions
#endif
PETSC_EXTERN void vectaggersetfromoptions_(VecTagger *a, PetscErrorCode *ierr)
{
  *ierr = VecTaggerSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggersetblocksize_ VECTAGGERSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggersetblocksize_ vectaggersetblocksize
#endif
PETSC_EXTERN void vectaggersetblocksize_(VecTagger *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = VecTaggerSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggergetblocksize_ VECTAGGERGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggergetblocksize_ vectaggergetblocksize
#endif
PETSC_EXTERN void vectaggergetblocksize_(VecTagger *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecTaggerGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggersetinvert_ VECTAGGERSETINVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggersetinvert_ vectaggersetinvert
#endif
PETSC_EXTERN void vectaggersetinvert_(VecTagger *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = VecTaggerSetInvert(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggergetinvert_ VECTAGGERGETINVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggergetinvert_ vectaggergetinvert
#endif
PETSC_EXTERN void vectaggergetinvert_(VecTagger *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = VecTaggerGetInvert(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggerview_ VECTAGGERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggerview_ vectaggerview
#endif
PETSC_EXTERN void vectaggerview_(VecTagger *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = VecTaggerView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercomputeis_ VECTAGGERCOMPUTEIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercomputeis_ vectaggercomputeis
#endif
PETSC_EXTERN void vectaggercomputeis_(VecTagger *a, Vec *b, IS c[], PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = VecTaggerComputeIS(*a, *b, c, d);
  if (*ierr) return;
}
