  type, extends(tPetscObject) ::  tPetscSF
  end type tPetscSF
  PetscSF, parameter :: PETSC_NULL_SF = tPetscSF(0)
  PetscSF, target :: PETSC_NULL_SF_ARRAY(1) = [tPetscSF(0)]
  PetscSF, pointer :: PETSC_NULL_SF_POINTER(:) => PETSC_NULL_SF_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SF
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SF_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SF_POINTER
#endif

  type tPetscSFLink
    PetscFortranAddr:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type tPetscSFLink
  PetscSFLink, parameter :: PETSC_NULL_SFLINK = tPetscSFLink(0)
  PetscSFLink, target :: PETSC_NULL_SFLINK_ARRAY(1) = [tPetscSFLink(0)]
  PetscSFLink, pointer :: PETSC_NULL_SFLINK_POINTER(:) => PETSC_NULL_SFLINK_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFLINK
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFLINK_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFLINK_POINTER
#endif

  type ePetscSFDirection
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFDirection

  PetscSFDirection, parameter :: PETSC_NULL_SFDIRECTION = ePetscSFDirection(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFDIRECTION
#endif
    PetscSFDirection, parameter :: PETSCSF_ROOT2LEAF = ePetscSFDirection(0)
    PetscSFDirection, parameter :: PETSCSF_LEAF2ROOT = ePetscSFDirection(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_ROOT2LEAF 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_LEAF2ROOT 
#endif

  type ePetscSFOperation
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFOperation

  PetscSFOperation, parameter :: PETSC_NULL_SFOPERATION = ePetscSFOperation(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFOPERATION
#endif
    PetscSFOperation, parameter :: PETSCSF_BCAST = ePetscSFOperation(0)
    PetscSFOperation, parameter :: PETSCSF_REDUCE = ePetscSFOperation(1)
    PetscSFOperation, parameter :: PETSCSF_FETCH = ePetscSFOperation(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_BCAST 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_REDUCE 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_FETCH 
#endif

  type ePetscSFBackend
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFBackend

  PetscSFBackend, parameter :: PETSC_NULL_SFBACKEND = ePetscSFBackend(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFBACKEND
#endif
    PetscSFBackend, parameter :: PETSCSF_BACKEND_INVALID = ePetscSFBackend(0)
    PetscSFBackend, parameter :: PETSCSF_BACKEND_CUDA = ePetscSFBackend(1)
    PetscSFBackend, parameter :: PETSCSF_BACKEND_HIP = ePetscSFBackend(2)
    PetscSFBackend, parameter :: PETSCSF_BACKEND_KOKKOS = ePetscSFBackend(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_BACKEND_INVALID 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_BACKEND_CUDA 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_BACKEND_HIP 
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_BACKEND_KOKKOS 
#endif

  type ePetscSFPattern
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFPattern

  PetscSFPattern, parameter :: PETSC_NULL_SFPATTERN = ePetscSFPattern(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFPATTERN
#endif
    PetscSFPattern, parameter :: PETSCSF_PATTERN_GENERAL = ePetscSFPattern(0)
    PetscSFPattern, parameter :: PETSCSF_PATTERN_ALLGATHER = ePetscSFPattern(1)
    PetscSFPattern, parameter :: PETSCSF_PATTERN_GATHER = ePetscSFPattern(2)
    PetscSFPattern, parameter :: PETSCSF_PATTERN_ALLTOALL = ePetscSFPattern(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_PATTERN_GENERAL
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_PATTERN_ALLGATHER
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_PATTERN_GATHER
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_PATTERN_ALLTOALL
#endif

  type ePetscSFWindowSyncType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFWindowSyncType

  PetscSFWindowSyncType, parameter :: PETSC_NULL_SFWINDOWSYNCTYPE = ePetscSFWindowSyncType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFWINDOWSYNCTYPE
#endif
    PetscSFWindowSyncType, parameter :: PETSCSF_WINDOW_SYNC_FENCE = ePetscSFWindowSyncType(0)
    PetscSFWindowSyncType, parameter :: PETSCSF_WINDOW_SYNC_LOCK = ePetscSFWindowSyncType(1)
    PetscSFWindowSyncType, parameter :: PETSCSF_WINDOW_SYNC_ACTIVE = ePetscSFWindowSyncType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_SYNC_FENCE
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_SYNC_LOCK
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_SYNC_ACTIVE
#endif

  type ePetscSFWindowFlavorType
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFWindowFlavorType

  PetscSFWindowFlavorType, parameter :: PETSC_NULL_SFWINDOWFLAVORTYPE = ePetscSFWindowFlavorType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFWINDOWFLAVORTYPE
#endif
    PetscSFWindowFlavorType, parameter :: PETSCSF_WINDOW_FLAVOR_CREATE = ePetscSFWindowFlavorType(0)
    PetscSFWindowFlavorType, parameter :: PETSCSF_WINDOW_FLAVOR_DYNAMIC = ePetscSFWindowFlavorType(1)
    PetscSFWindowFlavorType, parameter :: PETSCSF_WINDOW_FLAVOR_ALLOCATE = ePetscSFWindowFlavorType(2)
    PetscSFWindowFlavorType, parameter :: PETSCSF_WINDOW_FLAVOR_SHARED = ePetscSFWindowFlavorType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_FLAVOR_CREATE
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_FLAVOR_DYNAMIC
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_FLAVOR_ALLOCATE
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_WINDOW_FLAVOR_SHARED
#endif

  type ePetscSFDuplicateOption
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFDuplicateOption

  PetscSFDuplicateOption, parameter :: PETSC_NULL_SFDUPLICATEOPTION = ePetscSFDuplicateOption(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFDUPLICATEOPTION
#endif
    PetscSFDuplicateOption, parameter :: PETSCSF_DUPLICATE_CONFONLY = ePetscSFDuplicateOption(0)
    PetscSFDuplicateOption, parameter :: PETSCSF_DUPLICATE_RANKS = ePetscSFDuplicateOption(1)
    PetscSFDuplicateOption, parameter :: PETSCSF_DUPLICATE_GRAPH = ePetscSFDuplicateOption(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_DUPLICATE_CONFONLY
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_DUPLICATE_RANKS
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_DUPLICATE_GRAPH
#endif

  type ePetscSFConcatenateRootMode
    PetscEnum:: v = PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscSFConcatenateRootMode

  PetscSFConcatenateRootMode, parameter :: PETSC_NULL_SFCONCATENATEROOTMODE = ePetscSFConcatenateRootMode(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SFCONCATENATEROOTMODE
#endif
    PetscSFConcatenateRootMode, parameter :: PETSCSF_CONCATENATE_ROOTMODE_LOCAL = ePetscSFConcatenateRootMode(0)
    PetscSFConcatenateRootMode, parameter :: PETSCSF_CONCATENATE_ROOTMODE_SHARED = ePetscSFConcatenateRootMode(1)
    PetscSFConcatenateRootMode, parameter :: PETSCSF_CONCATENATE_ROOTMODE_GLOBAL = ePetscSFConcatenateRootMode(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_CONCATENATE_ROOTMODE_LOCAL
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_CONCATENATE_ROOTMODE_SHARED
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSF_CONCATENATE_ROOTMODE_GLOBAL
#endif

  CHARACTER(LEN=*), PARAMETER :: PETSCSFBASIC = 'basic'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFNEIGHBOR = 'neighbor'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFALLGATHERV = 'allgatherv'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFALLGATHER = 'allgather'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFGATHERV = 'gatherv'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFGATHER = 'gather'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFALLTOALL = 'alltoall'
  CHARACTER(LEN=*), PARAMETER :: PETSCSFWINDOW = 'window'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFBASIC
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFNEIGHBOR
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFALLGATHERV
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFALLGATHER
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFGATHERV
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFGATHER
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFALLTOALL
!DEC$ ATTRIBUTES DLLEXPORT::PETSCSFWINDOW
#endif

  type sPetscSFNode
    PetscInt rank
    PetscInt index
  end type sPetscSFNode

