#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscparallelsortint_ PETSCPARALLELSORTINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscparallelsortint_ petscparallelsortint
#endif
PETSC_EXTERN void petscparallelsortint_(PetscLayout *a, PetscLayout *b, PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscParallelSortInt(*a, *b, c, d);
  if (*ierr) return;
}
