#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreate_ PETSCSECTIONCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreate_ petscsectioncreate
#endif
PETSC_EXTERN void petscsectioncreate_(MPI_Fint *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSectionCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncopy_ PETSCSECTIONCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncopy_ petscsectioncopy
#endif
PETSC_EXTERN void petscsectioncopy_(PetscSection *a, PetscSection *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionCopy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionclone_ PETSCSECTIONCLONE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionclone_ petscsectionclone
#endif
PETSC_EXTERN void petscsectionclone_(PetscSection *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSectionClone(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfromoptions_ PETSCSECTIONSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfromoptions_ petscsectionsetfromoptions
#endif
PETSC_EXTERN void petscsectionsetfromoptions_(PetscSection *a, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncompare_ PETSCSECTIONCOMPARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncompare_ petscsectioncompare
#endif
PETSC_EXTERN void petscsectioncompare_(PetscSection *a, PetscSection *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSectionCompare(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetnumfields_ PETSCSECTIONGETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetnumfields_ petscsectiongetnumfields
#endif
PETSC_EXTERN void petscsectiongetnumfields_(PetscSection *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSectionGetNumFields(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetnumfields_ PETSCSECTIONSETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetnumfields_ petscsectionsetnumfields
#endif
PETSC_EXTERN void petscsectionsetnumfields_(PetscSection *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetNumFields(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldname_ PETSCSECTIONGETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldname_ petscsectiongetfieldname
#endif
PETSC_EXTERN void petscsectiongetfieldname_(PetscSection *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = PetscSectionGetFieldName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldname_ PETSCSECTIONSETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldname_ petscsectionsetfieldname
#endif
PETSC_EXTERN void petscsectionsetfieldname_(PetscSection *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscSectionSetFieldName(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetcomponentname_ PETSCSECTIONGETCOMPONENTNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetcomponentname_ petscsectiongetcomponentname
#endif
PETSC_EXTERN void petscsectiongetcomponentname_(PetscSection *a, PetscInt *b, PetscInt *c, char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_d = PETSC_NULLPTR;
  *ierr = PetscSectionGetComponentName(*a, *b, *c, (const char **)&c_d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)d, c_d, l_d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetcomponentname_ PETSCSECTIONSETCOMPONENTNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetcomponentname_ petscsectionsetcomponentname
#endif
PETSC_EXTERN void petscsectionsetcomponentname_(PetscSection *a, PetscInt *b, PetscInt *c, char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  *ierr = PetscSectionSetComponentName(*a, *b, *c, c_d);
  if (*ierr) return;
  FREECHAR(d, c_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldcomponents_ PETSCSECTIONGETFIELDCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldcomponents_ petscsectiongetfieldcomponents
#endif
PETSC_EXTERN void petscsectiongetfieldcomponents_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetFieldComponents(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldcomponents_ PETSCSECTIONSETFIELDCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldcomponents_ petscsectionsetfieldcomponents
#endif
PETSC_EXTERN void petscsectionsetfieldcomponents_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFieldComponents(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetchart_ PETSCSECTIONGETCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetchart_ petscsectiongetchart
#endif
PETSC_EXTERN void petscsectiongetchart_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetChart(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetchart_ PETSCSECTIONSETCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetchart_ petscsectionsetchart
#endif
PETSC_EXTERN void petscsectionsetchart_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetChart(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetpermutation_ PETSCSECTIONGETPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetpermutation_ petscsectiongetpermutation
#endif
PETSC_EXTERN void petscsectiongetpermutation_(PetscSection *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSectionGetPermutation(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetpermutation_ PETSCSECTIONSETPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetpermutation_ petscsectionsetpermutation
#endif
PETSC_EXTERN void petscsectionsetpermutation_(PetscSection *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetPermutation(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetpointmajor_ PETSCSECTIONGETPOINTMAJOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetpointmajor_ petscsectiongetpointmajor
#endif
PETSC_EXTERN void petscsectiongetpointmajor_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSectionGetPointMajor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetpointmajor_ PETSCSECTIONSETPOINTMAJOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetpointmajor_ petscsectionsetpointmajor
#endif
PETSC_EXTERN void petscsectionsetpointmajor_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetPointMajor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetincludesconstraints_ PETSCSECTIONGETINCLUDESCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetincludesconstraints_ petscsectiongetincludesconstraints
#endif
PETSC_EXTERN void petscsectiongetincludesconstraints_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSectionGetIncludesConstraints(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetincludesconstraints_ PETSCSECTIONSETINCLUDESCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetincludesconstraints_ petscsectionsetincludesconstraints
#endif
PETSC_EXTERN void petscsectionsetincludesconstraints_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetIncludesConstraints(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetdof_ PETSCSECTIONGETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetdof_ petscsectiongetdof
#endif
PETSC_EXTERN void petscsectiongetdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetDof(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetdof_ PETSCSECTIONSETDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetdof_ petscsectionsetdof
#endif
PETSC_EXTERN void petscsectionsetdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetDof(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionadddof_ PETSCSECTIONADDDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionadddof_ petscsectionadddof
#endif
PETSC_EXTERN void petscsectionadddof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionAddDof(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfielddof_ PETSCSECTIONGETFIELDDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfielddof_ petscsectiongetfielddof
#endif
PETSC_EXTERN void petscsectiongetfielddof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSectionGetFieldDof(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfielddof_ PETSCSECTIONSETFIELDDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfielddof_ petscsectionsetfielddof
#endif
PETSC_EXTERN void petscsectionsetfielddof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFieldDof(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionaddfielddof_ PETSCSECTIONADDFIELDDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionaddfielddof_ petscsectionaddfielddof
#endif
PETSC_EXTERN void petscsectionaddfielddof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionAddFieldDof(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetconstraintdof_ PETSCSECTIONGETCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetconstraintdof_ petscsectiongetconstraintdof
#endif
PETSC_EXTERN void petscsectiongetconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetConstraintDof(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetconstraintdof_ PETSCSECTIONSETCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetconstraintdof_ petscsectionsetconstraintdof
#endif
PETSC_EXTERN void petscsectionsetconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetConstraintDof(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionaddconstraintdof_ PETSCSECTIONADDCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionaddconstraintdof_ petscsectionaddconstraintdof
#endif
PETSC_EXTERN void petscsectionaddconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionAddConstraintDof(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldconstraintdof_ PETSCSECTIONGETFIELDCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldconstraintdof_ petscsectiongetfieldconstraintdof
#endif
PETSC_EXTERN void petscsectiongetfieldconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSectionGetFieldConstraintDof(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldconstraintdof_ PETSCSECTIONSETFIELDCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldconstraintdof_ petscsectionsetfieldconstraintdof
#endif
PETSC_EXTERN void petscsectionsetfieldconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFieldConstraintDof(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionaddfieldconstraintdof_ PETSCSECTIONADDFIELDCONSTRAINTDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionaddfieldconstraintdof_ petscsectionaddfieldconstraintdof
#endif
PETSC_EXTERN void petscsectionaddfieldconstraintdof_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionAddFieldConstraintDof(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetupbc_ PETSCSECTIONSETUPBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetupbc_ petscsectionsetupbc
#endif
PETSC_EXTERN void petscsectionsetupbc_(PetscSection *a, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetUpBC(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetup_ PETSCSECTIONSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetup_ petscsectionsetup
#endif
PETSC_EXTERN void petscsectionsetup_(PetscSection *a, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetmaxdof_ PETSCSECTIONGETMAXDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetmaxdof_ petscsectiongetmaxdof
#endif
PETSC_EXTERN void petscsectiongetmaxdof_(PetscSection *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSectionGetMaxDof(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetstoragesize_ PETSCSECTIONGETSTORAGESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetstoragesize_ petscsectiongetstoragesize
#endif
PETSC_EXTERN void petscsectiongetstoragesize_(PetscSection *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSectionGetStorageSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetconstrainedstoragesize_ PETSCSECTIONGETCONSTRAINEDSTORAGESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetconstrainedstoragesize_ petscsectiongetconstrainedstoragesize
#endif
PETSC_EXTERN void petscsectiongetconstrainedstoragesize_(PetscSection *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSectionGetConstrainedStorageSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreateglobalsection_ PETSCSECTIONCREATEGLOBALSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreateglobalsection_ petscsectioncreateglobalsection
#endif
PETSC_EXTERN void petscsectioncreateglobalsection_(PetscSection *a, PetscSF *b, PetscBool *c, PetscBool *d, PetscBool *e, PetscSection *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscSectionCreateGlobalSection(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, *e ? PETSC_TRUE : PETSC_FALSE, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreateglobalsectioncensored_ PETSCSECTIONCREATEGLOBALSECTIONCENSORED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreateglobalsectioncensored_ petscsectioncreateglobalsectioncensored
#endif
PETSC_EXTERN void petscsectioncreateglobalsectioncensored_(PetscSection *a, PetscSF *b, PetscBool *c, PetscInt *d, const PetscInt e[], PetscSection *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscSectionCreateGlobalSectionCensored(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetpointlayout_ PETSCSECTIONGETPOINTLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetpointlayout_ petscsectiongetpointlayout
#endif
PETSC_EXTERN void petscsectiongetpointlayout_(MPI_Fint *a, PetscSection *b, PetscLayout *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionGetPointLayout(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetvaluelayout_ PETSCSECTIONGETVALUELAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetvaluelayout_ petscsectiongetvaluelayout
#endif
PETSC_EXTERN void petscsectiongetvaluelayout_(MPI_Fint *a, PetscSection *b, PetscLayout *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionGetValueLayout(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetoffset_ PETSCSECTIONGETOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetoffset_ petscsectiongetoffset
#endif
PETSC_EXTERN void petscsectiongetoffset_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetOffset(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetoffset_ PETSCSECTIONSETOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetoffset_ petscsectionsetoffset
#endif
PETSC_EXTERN void petscsectionsetoffset_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetOffset(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldoffset_ PETSCSECTIONGETFIELDOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldoffset_ petscsectiongetfieldoffset
#endif
PETSC_EXTERN void petscsectiongetfieldoffset_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSectionGetFieldOffset(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldoffset_ PETSCSECTIONSETFIELDOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldoffset_ petscsectionsetfieldoffset
#endif
PETSC_EXTERN void petscsectionsetfieldoffset_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFieldOffset(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldpointoffset_ PETSCSECTIONGETFIELDPOINTOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldpointoffset_ petscsectiongetfieldpointoffset
#endif
PETSC_EXTERN void petscsectiongetfieldpointoffset_(PetscSection *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSectionGetFieldPointOffset(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetoffsetrange_ PETSCSECTIONGETOFFSETRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetoffsetrange_ petscsectiongetoffsetrange
#endif
PETSC_EXTERN void petscsectiongetoffsetrange_(PetscSection *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionGetOffsetRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreatesubsection_ PETSCSECTIONCREATESUBSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreatesubsection_ petscsectioncreatesubsection
#endif
PETSC_EXTERN void petscsectioncreatesubsection_(PetscSection *a, PetscInt *b, const PetscInt c[], PetscSection *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscSectionCreateSubsection(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreatecomponentsubsection_ PETSCSECTIONCREATECOMPONENTSUBSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreatecomponentsubsection_ petscsectioncreatecomponentsubsection
#endif
PETSC_EXTERN void petscsectioncreatecomponentsubsection_(PetscSection *a, PetscInt *b, const PetscInt c[], PetscSection *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscSectionCreateComponentSubsection(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreatesupersection_ PETSCSECTIONCREATESUPERSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreatesupersection_ petscsectioncreatesupersection
#endif
PETSC_EXTERN void petscsectioncreatesupersection_(PetscSection a[], PetscInt *b, PetscSection *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionCreateSupersection(a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreatesubmeshsection_ PETSCSECTIONCREATESUBMESHSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreatesubmeshsection_ petscsectioncreatesubmeshsection
#endif
PETSC_EXTERN void petscsectioncreatesubmeshsection_(PetscSection *a, IS *b, PetscSection *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionCreateSubmeshSection(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreatesubdomainsection_ PETSCSECTIONCREATESUBDOMAINSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreatesubdomainsection_ petscsectioncreatesubdomainsection
#endif
PETSC_EXTERN void petscsectioncreatesubdomainsection_(PetscSection *a, IS *b, PetscSection *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionCreateSubdomainSection(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionviewfromoptions_ PETSCSECTIONVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionviewfromoptions_ petscsectionviewfromoptions
#endif
PETSC_EXTERN void petscsectionviewfromoptions_(PetscSection *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscSectionViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionview_ PETSCSECTIONVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionview_ petscsectionview
#endif
PETSC_EXTERN void petscsectionview_(PetscSection *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscSectionView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionload_ PETSCSECTIONLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionload_ petscsectionload
#endif
PETSC_EXTERN void petscsectionload_(PetscSection *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscSectionLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionarrayview_ PETSCSECTIONARRAYVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionarrayview_ petscsectionarrayview
#endif
PETSC_EXTERN void petscsectionarrayview_(PetscSection *a, void *b, PetscDataType *c, PetscViewer *d, PetscErrorCode *ierr)
{
  PetscViewer v_d = PetscPatchDefaultViewers(d);
  *ierr = PetscSectionArrayView(*a, b, *c, v_d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionresetclosurepermutation_ PETSCSECTIONRESETCLOSUREPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionresetclosurepermutation_ petscsectionresetclosurepermutation
#endif
PETSC_EXTERN void petscsectionresetclosurepermutation_(PetscSection *a, PetscErrorCode *ierr)
{
  *ierr = PetscSectionResetClosurePermutation(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionreset_ PETSCSECTIONRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionreset_ petscsectionreset
#endif
PETSC_EXTERN void petscsectionreset_(PetscSection *a, PetscErrorCode *ierr)
{
  *ierr = PetscSectionReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiondestroy_ PETSCSECTIONDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiondestroy_ petscsectiondestroy
#endif
PETSC_EXTERN void petscsectiondestroy_(PetscSection *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscSectionDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionhasconstraints_ PETSCSECTIONHASCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionhasconstraints_ petscsectionhasconstraints
#endif
PETSC_EXTERN void petscsectionhasconstraints_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSectionHasConstraints(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetconstraintindices_ PETSCSECTIONSETCONSTRAINTINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetconstraintindices_ petscsectionsetconstraintindices
#endif
PETSC_EXTERN void petscsectionsetconstraintindices_(PetscSection *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSectionSetConstraintIndices(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldconstraintindices_ PETSCSECTIONSETFIELDCONSTRAINTINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldconstraintindices_ petscsectionsetfieldconstraintindices
#endif
PETSC_EXTERN void petscsectionsetfieldconstraintindices_(PetscSection *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSectionSetFieldConstraintIndices(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionpermute_ PETSCSECTIONPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionpermute_ petscsectionpermute
#endif
PETSC_EXTERN void petscsectionpermute_(PetscSection *a, IS *b, PetscSection *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionPermute(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetclosureindex_ PETSCSECTIONSETCLOSUREINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetclosureindex_ petscsectionsetclosureindex
#endif
PETSC_EXTERN void petscsectionsetclosureindex_(PetscSection *a, PetscObject *b, PetscSection *c, IS *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetClosureIndex(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetclosureindex_ PETSCSECTIONGETCLOSUREINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetclosureindex_ petscsectiongetclosureindex
#endif
PETSC_EXTERN void petscsectiongetclosureindex_(PetscSection *a, PetscObject *b, PetscSection *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscSectionGetClosureIndex(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetclosurepermutation_ PETSCSECTIONSETCLOSUREPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetclosurepermutation_ petscsectionsetclosurepermutation
#endif
PETSC_EXTERN void petscsectionsetclosurepermutation_(PetscSection *a, PetscObject *b, PetscInt *c, IS *d, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetClosurePermutation(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetclosurepermutation_ PETSCSECTIONGETCLOSUREPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetclosurepermutation_ petscsectiongetclosurepermutation
#endif
PETSC_EXTERN void petscsectiongetclosurepermutation_(PetscSection *a, PetscObject *b, PetscInt *c, PetscInt *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscSectionGetClosurePermutation(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetclosureinversepermutation_ PETSCSECTIONGETCLOSUREINVERSEPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetclosureinversepermutation_ petscsectiongetclosureinversepermutation
#endif
PETSC_EXTERN void petscsectiongetclosureinversepermutation_(PetscSection *a, PetscObject *b, PetscInt *c, PetscInt *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscSectionGetClosureInversePermutation(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfield_ PETSCSECTIONGETFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfield_ petscsectiongetfield
#endif
PETSC_EXTERN void petscsectiongetfield_(PetscSection *a, PetscInt *b, PetscSection *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionGetField(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetsym_ PETSCSECTIONSETSYM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetsym_ petscsectionsetsym
#endif
PETSC_EXTERN void petscsectionsetsym_(PetscSection *a, PetscSectionSym *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetSym(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetsym_ PETSCSECTIONGETSYM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetsym_ petscsectiongetsym
#endif
PETSC_EXTERN void petscsectiongetsym_(PetscSection *a, PetscSectionSym *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSectionGetSym(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetfieldsym_ PETSCSECTIONSETFIELDSYM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetfieldsym_ petscsectionsetfieldsym
#endif
PETSC_EXTERN void petscsectionsetfieldsym_(PetscSection *a, PetscInt *b, PetscSectionSym *c, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetFieldSym(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetfieldsym_ PETSCSECTIONGETFIELDSYM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetfieldsym_ petscsectiongetfieldsym
#endif
PETSC_EXTERN void petscsectiongetfieldsym_(PetscSection *a, PetscInt *b, PetscSectionSym *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionGetFieldSym(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectiongetusefieldoffsets_ PETSCSECTIONGETUSEFIELDOFFSETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectiongetusefieldoffsets_ petscsectiongetusefieldoffsets
#endif
PETSC_EXTERN void petscsectiongetusefieldoffsets_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSectionGetUseFieldOffsets(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsetusefieldoffsets_ PETSCSECTIONSETUSEFIELDOFFSETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsetusefieldoffsets_ petscsectionsetusefieldoffsets
#endif
PETSC_EXTERN void petscsectionsetusefieldoffsets_(PetscSection *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSetUseFieldOffsets(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymcreate_ PETSCSECTIONSYMCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymcreate_ petscsectionsymcreate
#endif
PETSC_EXTERN void petscsectionsymcreate_(MPI_Fint *a, PetscSectionSym *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSectionSymCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymsettype_ PETSCSECTIONSYMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymsettype_ petscsectionsymsettype
#endif
PETSC_EXTERN void petscsectionsymsettype_(PetscSectionSym *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscSectionSymSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymgettype_ PETSCSECTIONSYMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymgettype_ petscsectionsymgettype
#endif
PETSC_EXTERN void petscsectionsymgettype_(PetscSectionSym *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscSectionSymGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymdestroy_ PETSCSECTIONSYMDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymdestroy_ petscsectionsymdestroy
#endif
PETSC_EXTERN void petscsectionsymdestroy_(PetscSectionSym *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscSectionSymDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymview_ PETSCSECTIONSYMVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymview_ petscsectionsymview
#endif
PETSC_EXTERN void petscsectionsymview_(PetscSectionSym *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscSectionSymView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymcopy_ PETSCSECTIONSYMCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymcopy_ petscsectionsymcopy
#endif
PETSC_EXTERN void petscsectionsymcopy_(PetscSectionSym *a, PetscSectionSym *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSymCopy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsection.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymdistribute_ PETSCSECTIONSYMDISTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymdistribute_ petscsectionsymdistribute
#endif
PETSC_EXTERN void petscsectionsymdistribute_(PetscSectionSym *a, PetscSF *b, PetscSectionSym *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionSymDistribute(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
