#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhsjacobianp_ TSCOMPUTERHSJACOBIANP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhsjacobianp_ tscomputerhsjacobianp
#endif
PETSC_EXTERN void tscomputerhsjacobianp_(TS *a, PetscReal *b, Vec *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TSComputeRHSJacobianP(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeijacobianp_ TSCOMPUTEIJACOBIANP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeijacobianp_ tscomputeijacobianp
#endif
PETSC_EXTERN void tscomputeijacobianp_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, PetscBool *g, PetscErrorCode *ierr)
{
  *ierr = TSComputeIJacobianP(*a, *b, *c, *d, *e, *f, *g ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetcostintegral_ TSGETCOSTINTEGRAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetcostintegral_ tsgetcostintegral
#endif
PETSC_EXTERN void tsgetcostintegral_(TS *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGetCostIntegral(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputecostintegrand_ TSCOMPUTECOSTINTEGRAND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputecostintegrand_ tscomputecostintegrand
#endif
PETSC_EXTERN void tscomputecostintegrand_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = TSComputeCostIntegrand(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeihessianproductfunctionuu_ TSCOMPUTEIHESSIANPRODUCTFUNCTIONUU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeihessianproductfunctionuu_ tscomputeihessianproductfunctionuu
#endif
PETSC_EXTERN void tscomputeihessianproductfunctionuu_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeIHessianProductFunctionUU(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeihessianproductfunctionup_ TSCOMPUTEIHESSIANPRODUCTFUNCTIONUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeihessianproductfunctionup_ tscomputeihessianproductfunctionup
#endif
PETSC_EXTERN void tscomputeihessianproductfunctionup_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeIHessianProductFunctionUP(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeihessianproductfunctionpu_ TSCOMPUTEIHESSIANPRODUCTFUNCTIONPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeihessianproductfunctionpu_ tscomputeihessianproductfunctionpu
#endif
PETSC_EXTERN void tscomputeihessianproductfunctionpu_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeIHessianProductFunctionPU(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputeihessianproductfunctionpp_ TSCOMPUTEIHESSIANPRODUCTFUNCTIONPP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputeihessianproductfunctionpp_ tscomputeihessianproductfunctionpp
#endif
PETSC_EXTERN void tscomputeihessianproductfunctionpp_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeIHessianProductFunctionPP(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhshessianproductfunctionuu_ TSCOMPUTERHSHESSIANPRODUCTFUNCTIONUU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhshessianproductfunctionuu_ tscomputerhshessianproductfunctionuu
#endif
PETSC_EXTERN void tscomputerhshessianproductfunctionuu_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeRHSHessianProductFunctionUU(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhshessianproductfunctionup_ TSCOMPUTERHSHESSIANPRODUCTFUNCTIONUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhshessianproductfunctionup_ tscomputerhshessianproductfunctionup
#endif
PETSC_EXTERN void tscomputerhshessianproductfunctionup_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeRHSHessianProductFunctionUP(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhshessianproductfunctionpu_ TSCOMPUTERHSHESSIANPRODUCTFUNCTIONPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhshessianproductfunctionpu_ tscomputerhshessianproductfunctionpu
#endif
PETSC_EXTERN void tscomputerhshessianproductfunctionpu_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeRHSHessianProductFunctionPU(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputerhshessianproductfunctionpp_ TSCOMPUTERHSHESSIANPRODUCTFUNCTIONPP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputerhshessianproductfunctionpp_ tscomputerhshessianproductfunctionpp
#endif
PETSC_EXTERN void tscomputerhshessianproductfunctionpp_(TS *a, PetscReal *b, Vec *c, Vec d[], Vec *e, Vec f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = TSComputeRHSHessianProductFunctionPP(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetcostgradients_ TSSETCOSTGRADIENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetcostgradients_ tssetcostgradients
#endif
PETSC_EXTERN void tssetcostgradients_(TS *a, PetscInt *b, Vec c[], Vec d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = TSSetCostGradients(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tssetcosthessianproducts_ TSSETCOSTHESSIANPRODUCTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tssetcosthessianproducts_ tssetcosthessianproducts
#endif
PETSC_EXTERN void tssetcosthessianproducts_(TS *a, PetscInt *b, Vec c[], Vec d[], Vec *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = TSSetCostHessianProducts(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointsetforward_ TSADJOINTSETFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointsetforward_ tsadjointsetforward
#endif
PETSC_EXTERN void tsadjointsetforward_(TS *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TSAdjointSetForward(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointresetforward_ TSADJOINTRESETFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointresetforward_ tsadjointresetforward
#endif
PETSC_EXTERN void tsadjointresetforward_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointResetForward(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointsetup_ TSADJOINTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointsetup_ tsadjointsetup
#endif
PETSC_EXTERN void tsadjointsetup_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointreset_ TSADJOINTRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointreset_ tsadjointreset
#endif
PETSC_EXTERN void tsadjointreset_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointsetsteps_ TSADJOINTSETSTEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointsetsteps_ tsadjointsetsteps
#endif
PETSC_EXTERN void tsadjointsetsteps_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSAdjointSetSteps(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointmonitorcancel_ TSADJOINTMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointmonitorcancel_ tsadjointmonitorcancel
#endif
PETSC_EXTERN void tsadjointmonitorcancel_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointmonitordefault_ TSADJOINTMONITORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointmonitordefault_ tsadjointmonitordefault
#endif
PETSC_EXTERN void tsadjointmonitordefault_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscInt *e, Vec f[], Vec g[], PetscViewerAndFormat **h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = TSAdjointMonitorDefault(*a, *b, *c, *d, *e, f, g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointmonitordrawsensi_ TSADJOINTMONITORDRAWSENSI
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointmonitordrawsensi_ tsadjointmonitordrawsensi
#endif
PETSC_EXTERN void tsadjointmonitordrawsensi_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscInt *e, Vec f[], Vec g[], void *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = TSAdjointMonitorDrawSensi(*a, *b, *c, *d, *e, f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointsetfromoptions_ TSADJOINTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointsetfromoptions_ tsadjointsetfromoptions
#endif
PETSC_EXTERN void tsadjointsetfromoptions_(TS *a, PetscOptionItems *b, PetscErrorCode *ierr)
{
  *ierr = TSAdjointSetFromOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointstep_ TSADJOINTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointstep_ tsadjointstep
#endif
PETSC_EXTERN void tsadjointstep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointsolve_ TSADJOINTSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointsolve_ tsadjointsolve
#endif
PETSC_EXTERN void tsadjointsolve_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointSolve(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointmonitor_ TSADJOINTMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointmonitor_ tsadjointmonitor
#endif
PETSC_EXTERN void tsadjointmonitor_(TS *a, PetscInt *b, PetscReal *c, Vec *d, PetscInt *e, Vec f[], Vec g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = TSAdjointMonitor(*a, *b, *c, *d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadjointcostintegral_ TSADJOINTCOSTINTEGRAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadjointcostintegral_ tsadjointcostintegral
#endif
PETSC_EXTERN void tsadjointcostintegral_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSAdjointCostIntegral(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardsetup_ TSFORWARDSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardsetup_ tsforwardsetup
#endif
PETSC_EXTERN void tsforwardsetup_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSForwardSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardreset_ TSFORWARDRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardreset_ tsforwardreset
#endif
PETSC_EXTERN void tsforwardreset_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSForwardReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardstep_ TSFORWARDSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardstep_ tsforwardstep
#endif
PETSC_EXTERN void tsforwardstep_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSForwardStep(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardsetsensitivities_ TSFORWARDSETSENSITIVITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardsetsensitivities_ tsforwardsetsensitivities
#endif
PETSC_EXTERN void tsforwardsetsensitivities_(TS *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = TSForwardSetSensitivities(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardgetsensitivities_ TSFORWARDGETSENSITIVITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardgetsensitivities_ tsforwardgetsensitivities
#endif
PETSC_EXTERN void tsforwardgetsensitivities_(TS *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSForwardGetSensitivities(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardcostintegral_ TSFORWARDCOSTINTEGRAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardcostintegral_ tsforwardcostintegral
#endif
PETSC_EXTERN void tsforwardcostintegral_(TS *a, PetscErrorCode *ierr)
{
  *ierr = TSForwardCostIntegral(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsforwardsetinitialsensitivities_ TSFORWARDSETINITIALSENSITIVITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsforwardsetinitialsensitivities_ tsforwardsetinitialsensitivities
#endif
PETSC_EXTERN void tsforwardsetinitialsensitivities_(TS *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TSForwardSetInitialSensitivities(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscreatequadraturets_ TSCREATEQUADRATURETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscreatequadraturets_ tscreatequadraturets
#endif
PETSC_EXTERN void tscreatequadraturets_(TS *a, PetscBool *b, TS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSCreateQuadratureTS(*a, *b ? PETSC_TRUE : PETSC_FALSE, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgetquadraturets_ TSGETQUADRATURETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgetquadraturets_ tsgetquadraturets
#endif
PETSC_EXTERN void tsgetquadraturets_(TS *a, PetscBool *b, TS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TSGetQuadratureTS(*a, b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tscomputesnesjacobian_ TSCOMPUTESNESJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tscomputesnesjacobian_ tscomputesnesjacobian
#endif
PETSC_EXTERN void tscomputesnesjacobian_(TS *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TSComputeSNESJacobian(*a, *b, *c, *d);
  if (*ierr) return;
}
